<?php
require_once __DIR__ . '/db.php';
require_once __DIR__ . '/Partie.php';
require_once __DIR__ . '/Vaisseau.php';
require_once __DIR__ . '/Personne.php';
require_once __DIR__ . '/Operateur.php';
require_once __DIR__ . '/Mentaliste.php';
require_once __DIR__ . '/Chasseur.php';
require_once __DIR__ . '/Bonus.php';
require_once __DIR__ . '/Drone.php';

header('Content-Type: application/json');
$action = $_GET['action'] ?? '';

// --- MENU ---
if ($action === 'creer') {
    $code = Partie::creerNouvellePartie($pdo);
    $id = $pdo->query("SELECT id FROM parties WHERE code_acces='$code'")->fetchColumn();
    echo json_encode(['success' => true, 'code' => $code, 'id' => $id]);
    exit;
}

if ($action === 'rejoindre') {
    $code = $_GET['code'] ?? '';
    $partie = Partie::rejoindrePartie($pdo, $code);
    if ($partie) { $partie->sauvegarder($pdo); echo json_encode(['success' => true, 'id' => $partie->idBdd]); }
    else echo json_encode(['success' => false]);
    exit;
}

// NOUVEAU : Créer une partie SOLO contre l'IA
if ($action === 'creer_solo') {
    $difficulte = $_GET['difficulte'] ?? 'moyen';
    if (!in_array($difficulte, ['facile', 'moyen', 'difficile'])) {
        $difficulte = 'moyen';
    }
    $result = Partie::creerPartieSolo($pdo, $difficulte);
    echo json_encode(['success' => true, 'code' => $result['code'], 'id' => $result['id']]);
    exit;
}

// NOUVEAU : Faire jouer l'IA
if ($action === 'jouer_ia') {
    $id = $_GET['id'] ?? null;
    if ($id) {
        $partie = Partie::getEtatViaId($pdo, $id);
        if ($partie && $partie->estTourIA()) {
            usleep(rand(500000, 1500000));
            $partie->jouerTourIA();
            $partie->sauvegarder($pdo);
            echo json_encode(['success' => true, 'ia_played' => true]);
        } else {
            echo json_encode(['success' => true, 'ia_played' => false]);
        }
    }
    exit;
}

// --- JEU ---
$id = $_POST['id'] ?? $_GET['id'] ?? null;
$role = $_POST['role'] ?? $_GET['role'] ?? null;

if ($id && $role) {
    $partie = Partie::getEtatViaId($pdo, $id);
    if (!$partie) exit(json_encode(['error' => 'Partie introuvable']));

    $sauvegarder = false;

    // 1. QUICK CHAT
    if ($action === 'chat') {
        $key = $_POST['key'] ?? '';
        if (array_key_exists($key, Partie::QUICK_MSGS)) {
            $partie->nouveauMessage(Partie::QUICK_MSGS[$key], $role);
            $sauvegarder = true;
        }
    }
    
    // 2. ACTIONS
    elseif ($role == $partie->joueurActif && $partie->gagnant === null) {
        $vaisseau = $partie->getVaisseauActif();
        $adversaire = ($role == 1) ? $partie->joueur2 : $partie->joueur1;
        
        if ($action === 'bouger') {
            $advPos = $adversaire->getPos();
            $res = $vaisseau->seDeplacer((int)$_POST['x'], (int)$_POST['y'], $partie->phase, $advPos['x'], $advPos['y']);
            
            if ($res === true) {
                $partie->verifierBonus($vaisseau); $partie->nouveauMessage("Le Joueur $role se déplace.", 0); $partie->passerTour(); $sauvegarder = true;
            }
        }
        elseif ($action === 'attendre') {
            $vaisseau->rechargerEnergie(3);
            $msg = ($vaisseau->bloqueMouvement > 0) ? "Le Joueur $role passe (Immobilisé)." : "Le Joueur $role se repose (+3⚡).";
            $partie->nouveauMessage($msg, 0); $partie->passerTour(); $sauvegarder = true;
        }
        elseif ($action === 'deployer') {
            if ($vaisseau->bloqueMouvement == 0 && $vaisseau->deployerDrone((int)$_POST['idx'])) {
                $partie->nouveauMessage("🛸 Le Joueur $role a déployé un drone !", 0); $partie->passerTour(); $sauvegarder = true;
            }
        }
        elseif ($action === 'attaque' && $partie->phase === 2) {
            $pv = $vaisseau->tirer($adversaire, $_POST['type']);
            if ($pv > -1) {
                $cible = ($role==1)?2:1; $arme = ($_POST['type']=='laser')?"Laser":"Plasma";
                $partie->nouveauMessage("💥 TIR RÉUSSI ! $arme. Joueur $cible a perdu $pv PV.", 0);
                $partie->verifierFinDePartie();
                if(!$partie->gagnant) $partie->passerTour();
                $sauvegarder = true;
            } else { 
                $partie->nouveauMessage("💨 TIR MANQUÉ par le Joueur $role.", 0); 
                if($pv === -1) $partie->passerTour(); 
                $sauvegarder = true; 
            }
        }
        elseif ($action === 'competence') {
            $type = $_POST['type'];
            if ($type === 'mentaliste') {
                $idx = $vaisseau->aUnMembrePret('Mentaliste');
                if ($idx > -1) { $vaisseau->utiliserMental iste($adversaire, $idx); $partie->nouveauMessage("🔮 ENTRAVE TOTALE (2 tours) !", 0); $partie->passerTour(); $sauvegarder = true; }
            }
            elseif ($type === 'operateur') {
                $idx = $vaisseau->aUnMembrePret('Operateur');
                if ($idx > -1) { $vaisseau->utiliserOperateur($adversaire, $idx); $partie->nouveauMessage("📡 BROUILLAGE ARMES (2 tours) !", 0); $partie->passerTour(); $sauvegarder = true; }
            }
            elseif ($type === 'tuer') {
                $idxC = $vaisseau->aUnMembrePret('Chasseur'); $idxT = (int)$_POST['cible'];
                if ($idxC > -1 && $adversaire->tuerMembre($idxT)) { $vaisseau->utiliserCompetence($idxC); $partie->nouveauMessage("🔫 ASSASSINAT RÉUSSI !", 0); $partie->passerTour(); $sauvegarder = true; }
            }
        }
    }

    if ($sauvegarder) $partie->sauvegarder($pdo);

    // --- GÉNÉRATION HTML (CODE ORIGINAL CONSERVÉ) ---
    
    $j1 = $partie->joueur1; $j2 = $partie->joueur2;
    $moi = ($role == 1) ? $j1 : $j2; $autre = ($role == 1) ? $j2 : $j1;
    $isMyTurn = ($role == $partie->joueurActif && $partie->gagnant === null);

    $html_top = "PHASE {$partie->phase} | TOUR {$partie->tour} | <span style='color:".($role==1?'#3498db':'#e74c3c')."'>JOUEUR $role</span>";
    $html_bonus = "Bonus: " . $partie->getToursRestantsBonus() . " tours restants";

    ob_start(); 
    ?>
    <h2 style="color: <?= $role==1?'#3498db':'#e74c3c' ?>">Moi</h2>
    <div class="stats-container">
        <?php if($moi->bouclier > 0): ?>
            <div class="bar-label"><span style="color:#3498db">Bouclier</span> <span><?= $moi->bouclier ?></span></div>
            <div class="bar-wrapper"><div class="bar-shield-fill" style="width: <?= min(100, $moi->bouclier*2.5) ?>%;"></div></div>
        <?php endif; ?>
        <div class="bar-label"><span style="color:#2ecc71">Structure</span> <span><?= $moi->getPv() ?>/100</span></div>
        <div class="bar-wrapper"><div class="bar-hp-fill" style="width: <?= $moi->getPv() ?>%;"></div></div>
    </div>
    <div>⚡: <strong><?= $moi->getEnergie() ?></strong></div>
    <?php if($moi->getBonusDegats() > 0): ?><span class="status-good">⚔️ Dégâts +<?= $moi->getBonusDegats() ?></span><?php endif; ?>
    <?php foreach($moi->dronesActifs as $d) echo "<span class='status-good'>🛸 {$d->nom} ({$d->duree}t)</span>"; ?>
    <?php if($moi->bloqueMouvement > 0): ?><span class="status-bad">⛔ PARALYSÉ (<?= $moi->bloqueMouvement ?>t)</span><?php endif; ?>
    <?php if($moi->bloqueTir > 0): ?><span class="status-bad">🔇 ARMES HS (<?= $moi->bloqueTir ?>t)</span><?php endif; ?>
    <hr><small>SOUTE :</small>
    <?php if(empty($moi->dronesStock)): ?><div style="font-size:0.8em;color:#777;">Vide</div><?php else: 
        foreach($moi->dronesStock as $idx => $d): 
        $nom = str_replace(['drone_atk','drone_def','drone_rep','drone_esq'], ['Attaque','Bouclier','Répa','Esquive'], $d->type);
        
        $canDeploy = $isMyTurn && $moi->bloqueMouvement == 0;
        $btnAttrs = $canDeploy ? "onclick=\"doAction('deployer', {idx: $idx})\"" : "disabled style='opacity:0.5; cursor:not-allowed'";
        ?>
        <div style="display:flex; justify-content:space-between; margin-top:4px;">
            <span style="font-size:0.8em">🛸 <?= $nom ?></span>
            <button <?= $btnAttrs ?> class="btn btn-drone">Activer</button>
        </div>
    <?php endforeach; endif; ?>
    <hr><small>ÉQUIPAGE :</small>
    <ul style="padding-left:20px; margin:5px 0; font-size:0.9em;">
        <?php foreach($moi->getEquipage() as $m): ?>
            <li><?= $m->getRole() ?> 
            <?php if($m instanceof Chasseur) echo "<span style='font-size:0.8em;color:#aaa;'>".$m->getStatus()."</span>";
                  elseif($m->estPret()) echo "<span style='color:#2ecc71;'>(Prêt)</span>";
                  else echo "<span style='color:#7f8c8d;'>(".$m->getCooldown()."t)</span>"; ?>
            </li>
        <?php endforeach; ?>
    </ul>
    <?php if($isMyTurn): ?>
        <hr>
        <?php if($moi->bloqueMouvement>0): ?>
            <div class="status-bad">TOUR PASSÉ</div><button onclick="doAction('attendre')" class="btn">Passer</button>
        <?php else: ?>
            <?php if($partie->phase===2 && $moi->bloqueTir==0): ?>
                <div style="display:flex; gap:5px;">
                    <?php 
                        $disLaser = ($moi->getEnergie() < 2) ? 'disabled style="opacity:0.5; cursor:not-allowed"' : '';
                        $disPlasma = ($moi->getEnergie() < 3) ? 'disabled style="opacity:0.5; cursor:not-allowed"' : '';
                    ?>
                    <button onclick="doAction('attaque', {type:'laser'})" class="btn btn-atk" <?= $disLaser ?>>Laser(2⚡)</button>
                    <button onclick="doAction('attaque', {type:'plasma'})" class="btn btn-atk" <?= $disPlasma ?>>Plasma(3⚡)</button>
                </div>
            <?php endif; ?>
            <?php if($moi->aUnMembrePret('Mentaliste')>-1 && $partie->phase===2): ?><button onclick="doAction('competence', {type:'mentaliste'})" class="btn btn-spe">🔮 Entrave</button><?php endif; ?>
            <?php if($moi->aUnMembrePret('Operateur')>-1 && $partie->phase===2): ?><button onclick="doAction('competence', {type:'operateur'})" class="btn btn-spe">📡 Brouillage</button><?php endif; ?>
            <?php if($moi->aUnMembrePret('Chasseur')>-1): foreach($autre->getEquipage() as $idx=>$en): ?>
                <button onclick="if(confirm('Tuer ?')) doAction('competence', {type:'tuer', cible:<?= $idx ?>})" class="btn btn-kill">Tuer <?= $en->getRole() ?></button>
            <?php endforeach; endif; ?>
            <button onclick="doAction('attendre')" class="btn">💤 Finir</button>
        <?php endif; ?>
    <?php else: ?>
        <div style="margin-top:20px; color:#777; font-style:italic;">Tour adverse...</div>
    <?php endif; ?>
    <?php 
    $html_moi = ob_get_clean();

    ob_start();
    $casesVertes = ($isMyTurn && $moi->bloqueMouvement == 0) ? $moi->getCasesAccessibles($partie->phase) : [];
    $advPos = $autre->getPos();

    function isAcc($x, $y, $cv) { foreach($cv as $c) if($c['x']==$ x && $c['y']==$y) return true; return false; }
    
    for($y=0; $y<8; $y++): for($x=0; $x<8; $x++): 
        $c=""; $cls="cell"; $evt=""; $vis=true;
        if($partie->phase===1) { if($role==1 && $y>3)$vis=false; if($role==2 && $y<4)$vis=false; }
        if(!$vis){ echo '<div class="cell fog"></div>'; continue; }
        
        if(isAcc($x, $y, $casesVertes)) { 
            if ($x == $advPos['x'] && $y == $advPos['y']) {
                $cls .= " occupied"; 
            } else {
                $cls .= " valid-move"; 
                $evt="onclick=\"doAction('bouger', {x:$x, y:$y})\""; 
            }
        }
        
        if($j1->getPos()['x']==$x && $j1->getPos()['y']==$y) $c='<div class="j1"></div>';
        elseif($j2->getPos()['x']==$x && $j2->getPos()['y']==$y) $c='<div class="j2"></div>';
        
        foreach($partie->bonusListe as $b) {
            if($b->x==$x && $b->y==$y) {
                if($b->type=='energie') $c.='<span class="bonus">⚡</span>';
                elseif($b->type=='personnage') $c.='<span class="bonus">👤</span>';
                el seif($b->type=='drone') $c.='<span class="bonus">🛸</span>';
            }
        }
        echo "<div class='$cls' $evt>$c</div>";
    endfor; endfor;
    $html_grid = ob_get_clean();

    ob_start(); ?>
    <h2 style="color: <?= $role==1?'#e74c3c':'#3498db' ?>">Adversaire</h2>
    <div class="stats-container">
        <?php if($autre->bouclier > 0): ?>
            <div class="bar-label"><span style="color:#3498db">Bouclier</span> <span><?= $autre->bouclier ?></span></div>
            <div class="bar-wrapper"><div class="bar-shield-fill" style="width: <?= min(100, $autre->bouclier*2.5) ?>%;"></div></div>
        <?php endif; ?>
        <div class="bar-label"><span style="color:#e74c3c">Structure</span> <span><?= $autre->getPv() ?>/100</span></div>
        <div class="bar-wrapper"><div class="bar-hp-fill" style="width: <?= $autre->getPv() ?>%;"></div></div>
    </div>
    <small>DRONES ACTIFS :</small>
    <?php if(empty($autre->dronesActifs)) echo "<div style='font-size:0.8em;color:#777'>Aucun</div>"; else foreach($autre->dronesActifs as $d) echo "<span class='status-good' style='border-color:#777; color:#aaa;'>🛸 {$d->nom}</span>"; ?>
    <?php if($autre->bloqueMouvement > 0): ?><span class="status-bad">⛔ PARALYSÉ</span><?php endif; ?>
    <?php if($autre->bloqueTir > 0): ?><span class="status-bad">🔇 BROUILLÉ</span><?php endif; ?>
    <hr><small>SCAN ÉQUIPAGE :</small>
    <ul style="padding-left:20px; margin:10px 0; font-size:0.9em; color:#aaa;">
        <?php foreach($autre->getEquipage() as $m): ?><li><?= $m->getRole() ?></li><?php endforeach; ?>
    </ul>
    <?php
    $html_adv = ob_get_clean();

    ob_start();
    foreach($partie->logs as $log) {
        $cls='msg-sys'; $aut='SYSTÈME';
        if($log['auteur']==1){$cls='msg-j1';$aut='JOUEUR 1';} if($log['auteur']==2){$cls='msg-j2';$aut='JOUEUR 2';}
        echo "<div class='log-line'><strong class='$cls'>$aut:</strong> {$log['texte']}</div>";
    }
    $html_logs = ob_get_clean();

    echo json_encode([
        'top' => $html_top,
        'bonus' => $html_bonus,
        'moi' => $html_moi,
        'grid' => $html_grid,
        'adv' => $html_adv,
        'logs' => $html_logs,
        'gagnant' => $partie->gagnant,
        'monRole' => $role,
        'estTourIA' => $partie->estTourIA(),
        'modeIA' => $partie->modeIA
    ]);
    exit;
}
?>