<?php

require_once 'Personne.php';
require_once 'Vaisseau.php';
require_once 'Partie.php';

session_start();

// CHARGER OU CRÉER LA PARTIE
if (!isset($_SESSION['partie'])) {
    // C'est une nouvelle partie !
    $partie = new Partie();
    $_SESSION['partie'] = $partie;
} else {
    // On charge la partie en cours depuis la mémoire
    $partie = $_SESSION['partie'];
}

// GÉRER L'ACTION DU JOUEUR (si le joueur a cliqué sur un bouton)
if (isset($_GET['action'])) {
    $partie->gererAction($_GET['action'], $_GET);
    // Après l'action, on passe le tour
    $partie->passerTour();
    
    // Et on sauvegarde le NOUVEL état du jeu dans la mémoire
    $_SESSION['partie'] = $partie;
}

// AFFICHER LE JEU (La "Vue")
// C'est ici que tu vas générer le HTML
echo "<h1>Tour " . $partie->getTourActuel() . " - Joueur " . $partie->getJoueurActif() . "</h1>";
// Tu auras besoin d'une méthode $partie->afficherGrilleEnHTML()
// Tu auras besoin d'une méthode $partie->afficherUI() (PV, Energie, boutons d'action)
?>