<?php
// Personne.php
abstract class Personne {
    protected $role;
    protected $pv;
    protected $cooldown;     // Tours restants avant de pouvoir utiliser la capacité
    protected $cooldownMax;  // Temps d'attente total après utilisation

    public function __construct(string $role, int $pv, int $cooldownMax) {
        $this->role = $role;
        $this->pv = $pv;
        $this->cooldown = 0; // La capacité est prête au début
        $this->cooldownMax = $cooldownMax;
    }

    public function getRole() { return $this->role; }
    public function getPv() { return $this->pv; }
    public function getCooldown() { return $this->cooldown; }

    // Réduit le cooldown à chaque tour
    public function passerTour() {
        if ($this->cooldown > 0) {
            $this->cooldown--;
        }
    }

    // Vérifie si la capacité est disponible
    public function estPret() {
        return $this->cooldown === 0;
    }

    // Active la capacité et lance le cooldown
    public function activerCooldown() {
        $this->cooldown = $this->cooldownMax;
    }

    public function subirDegats($montant) {
        $this->pv -= $montant;
        if ($this->pv < 0) $this->pv = 0;
    }

    public function estVivant() {
        return $this->pv > 0;
    }
}
?>