<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Le Malade Imaginaire</title>
  <style>
    /* Reset et global */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    body, html { height: 100%; font-family: Arial, sans-serif; }

    /* Bannière pleine largeur */
    .banner {
      position: relative;
      width: 100%;
      height: 0;
      padding-bottom: 56.25%; /* ratio 16:9 */
      background: url('votre-image.jpg') center/cover no-repeat;
    }
    /* Filtre sombre dégradé pour contraste texte */
    .banner::before {
      content: '';
      position: absolute;
      top: 0; left: 0; right: 0; bottom: 0;
      background: linear-gradient(90deg, rgba(0,0,0,0.8) 0%, rgba(0,0,0,0) 60%);
    }

    /* Contenu texte centré verticalement */
    .banner .content {
      position: absolute;
      top: 35%;
      left: 80px;
      transform: translateY(-35%);
      max-width: 480px;
      color: #fff;
    }
    .banner h1 {
      font-size: 2.5rem;
      margin-bottom: 16px;
      line-height: 1.1;
    }
    .banner p {
      font-size: 1rem;
      line-height: 1.5;
      margin-bottom: 24px;
    }
    /* Note étoiles et lien avis */
    .rating {
      display: flex;
      align-items: center;
      margin-bottom: 24px;
      font-size: 1rem;
    }
    .rating .stars {
      color: #FFD700;
      display: flex;
      gap: 4px;
      margin-right: 12px;
    }
    .rating .stars span {
      font-size: 1.25rem;
      line-height: 1;
    }
    .rating a {
      color: #fff;
      text-decoration: underline;
      opacity: 0.85;
      font-size: 0.9rem;
    }
    .rating a:hover { opacity: 1; }

    /* Boutons */
    .actions {
      display: flex;
      align-items: center;
      gap: 16px;
    }
    .btn {
      display: inline-block;
      padding: 12px 24px;
      border-radius: 24px;
      font-weight: bold;
      text-decoration: none;
      text-align: center;
      white-space: nowrap;
      cursor: pointer;
    }
    .btn-primary {
      background-color: #e60000;
      color: #fff;
    }
    .btn-secondary {
      background-color: transparent;
      color: #e60000;
      border: 1px solid #e60000;
    }
    .btn-primary:hover { opacity: 0.9; }
    .btn-secondary:hover { background-color: rgba(230,0,0,0.1); }

    /* Responsive */
    @media (max-width: 1024px) {
      .banner .content { left: 40px; max-width: 400px; }
      .banner h1 { font-size: 2rem; }
    }
    @media (max-width: 768px) {
      .banner .content { left: 24px; max-width: 80%; }
      .actions { flex-direction: column; align-items: flex-start; }
      .actions .btn { width: auto; }
    }
    @media (max-width: 480px) {
      .banner .content { left: 16px; max-width: 90%; }
      .banner h1 { font-size: 1.75rem; }
      .banner p { font-size: 0.9rem; }
      .rating { font-size: 0.85rem; }
    }
  </style>
</head>
<body>
  <section class="banner">
    <div class="content">
      <h1>LE MALADE IMAGINAIRE</h1>
      <p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quam amet, augue eget maecenas libero habitant eget. Cursus magna dapibus eu morbi ac egestas dolor. Sociis aliquam pretium tellus ac in augue. Cras suspendisse fusce cursus eu, morbi lorem cras nulla fermentum.</p>
      <div class="rating">
        <div class="stars">
          <span>★</span>
          <span>★</span>
          <span>★</span>
          <span>★</span>
          <span>☆</span>
        </div>
        <a href="#">Met ton avis personnel</a>
      </div>
      <div class="actions">
        <a href="#" class="btn btn-primary">Réserve ta place</a>
        <a href="#" class="btn btn-secondary">Bande annonce</a>
      </div>
    </div>
  </section>
</body>
</html>
