<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Hero Section</title>
  <style>
    /* Reset & Box sizing */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    html, body { height: 100%; }

    /* Hero container with 16:9 aspect ratio */
    .hero {
      position: relative;
      width: 100%;
      padding-top: 56.25%; /* 16:9 */
      background: url('background.jpg') center/cover no-repeat;
    }
    /* Dark overlay */
    .hero::after {
      content: '';
      position: absolute;
      top: 0; left: 0; right: 0; bottom: 0;
      background: rgba(0, 0, 0, 0.6);
    }

    /* Logo in top-left */
    .logo {
      position: absolute;
      top: 5%;
      left: 5%;
      display: flex;
      align-items: center;
      z-index: 1;
      color: #fff;
      font-family: sans-serif;
    }
    .logo-icon {
      width: 24px;
      height: 24px;
      background: url('icon.svg') center/contain no-repeat;
    }
    .logo-text {
      margin-left: 8px;
      font-size: 0.9rem;
      text-transform: uppercase;
      font-weight: 600;
    }

    /* Content block */
    .hero-content {
      position: absolute;
      top: 50%;
      left: 10%;
      transform: translateY(-50%);
      z-index: 1;
      max-width: 40%;
      color: #fff;
      font-family: sans-serif;
    }
    .hero-content h1 {
      font-size: 2.5vw;
      text-transform: uppercase;
      margin-bottom: 1rem;
      line-height: 1.2;
    }
    .hero-content p {
      font-size: 1vw;
      line-height: 1.5;
      margin-bottom: 1.5rem;
    }
    .btn {
      display: inline-block;
      padding: 0.75rem 1.5rem;
      background-color: #E30B17;
      color: #fff;
      text-decoration: none;
      border-radius: 4px;
      font-weight: 600;
      font-size: 1rem;
    }

    /* Mobile adjustments */
    @media (max-width: 768px) {
      .hero-content {
        left: 5%;
        max-width: 90%;
      }
      .hero-content h1 { font-size: 6vw; }
      .hero-content p { font-size: 3vw; }
    }
  </style>
</head>
<body>
  <div class="hero">
    <div class="logo">
      <div class="logo-icon"></div>
      <div class="logo-text">Nouvel Acte</div>
    </div>
    <div class="hero-content">
      <h1>Pourquoi scroller quand on peut le vivre</h1>
      <p>
        Lorem ipsum dolor sit amet, consectetur adipiscing elit. Quam amet, augue eget maecenas libero habitant eget. Curus magna dapibus eu morbi ac egestas dolor. Sociis aliquam pretium felis ac in augue. Cras suspendisse fusce cursus eu, morbi lorem cras nulla fermentum.
      </p>
      <a href="#" class="btn">Découvrir</a>
    </div>
  </div>
</body>
</html>
