<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8">
  <meta name="viewport" content="width=device-width, initial-scale=1.0">
  <title>Nouvel Acte - Connexion</title>
  <style>
    * {
      margin: 0;
      padding: 0;
      box-sizing: border-box;
    }

    html, body {
      height: 100%;
      font-family: 'Arial', sans-serif;
    }

    body {
      background: url('theatre.jpg') center center/cover no-repeat;
      display: flex;
      justify-content: center;
      align-items: center;
    }

    .logo {
      position: absolute;
      top: 30px;
      left: 50px;
      display: flex;
      align-items: center;
      font-size: 16px;
      color: white;
      font-weight: bold;
      gap: 8px;
    }
    .logo::before {
      content: '\25CF';
      color: red;
      font-size: 20px;
    }

    .card {
      background-color: #000;
      border-radius: 40px;
      padding: 50px 30px;
      width: 320px;
      text-align: center;
    }

    .card h1 {
      color: #fff;
      font-size: 24px;
      margin-bottom: 40px;
    }

    .card input {
      width: 100%;
      height: 40px;
      padding: 0 15px;
      margin-bottom: 20px;
      border: none;
      border-radius: 20px;
      font-size: 14px;
    }

    .card button {
      width: 100%;
      height: 40px;
      border: none;
      border-radius: 20px;
      background-color: #ff0000;
      color: #fff;
      font-size: 14px;
      font-weight: bold;
      cursor: pointer;
      margin-top: 10px;
    }

    @media (max-width: 360px) {
      .card {
        width: 90%;
        padding: 40px 20px;
      }
      .logo {
        top: 20px;
        left: 20px;
      }
    }
  </style>
</head>
<body>
  <div class="logo">NOUVEL ACTE</div>
  <div class="card">
    <h1>Identifiez-vous</h1>
    <input type="email" placeholder="E-mail">
    <input type="password" placeholder="Mot de passe">
    <button>M'identifier</button>
  </div>
</body>
</html>
