<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Nouvel Acte Dashboard</title>
  <style>
    /* Reset & box-sizing */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    html, body { height: 100%; font-family: sans-serif; }

    /* Couleurs */
    :root {
      --bg-dark: #0b0b0b;
      --bg-light: #1f1f1f;
      --accent-red: #E30B17;
      --text-white: #ffffff;
      --text-gray: #7a7a7a;
    }
    body { background: var(--bg-dark); color: var(--text-white); }

    /* Grid principal */
    .container {
      display: grid;
      grid-template-columns: 250px 1fr 250px;
      grid-template-rows: 60px 1fr;
      grid-template-areas:
        "sidebar header aside"
        "sidebar main aside";
      height: 100vh;
    }

    /* Sidebar */
    .sidebar {
      grid-area: sidebar;
      background: var(--bg-light);
      display: flex;
      flex-direction: column;
      justify-content: space-between;
      padding: 1.5rem;
    }
    .sidebar .logo { display: flex; align-items: center; margin-bottom: 2.5rem; }
    .logo-icon { width: 24px; height: 24px; background: url('icon.svg') center/contain no-repeat; }
    .logo-text { margin-left: 0.5rem; font-size: 1rem; text-transform: uppercase; font-weight: bold; color: var(--text-white); }
    .section-title { font-size: 0.75rem; text-transform: uppercase; color: var(--text-gray); margin-bottom: 1rem; }
    .nav-group { margin-bottom: 2rem; }
    .nav-group ul { list-style: none; }
    .nav-group li { display: flex; align-items: center; margin: 0.75rem 0; font-size: 0.9rem; cursor: pointer; color: var(--text-white); }
    .nav-group li .icon { width: 20px; height: 20px; background: var(--text-white) center/contain no-repeat; margin-right: 0.5rem; }
    .logout-group { margin-top: 2rem; }
    .logout-group .section-title { margin-bottom: 1rem; }
    .logout { display: flex; align-items: center; font-size: 0.9rem; cursor: pointer; color: var(--text-white); }
    .logout .icon { width: 20px; height: 20px; background: var(--text-white) center/contain no-repeat; margin-right: 0.5rem; }

    /* Header */
    .header {
      grid-area: header;
      position: relative;
      display: flex;
      align-items: center;
      justify-content: center;
      background: var(--bg-dark);
      padding: 0 1.5rem;
    }
    .search-box {
      width: 600px;
      max-width: calc(100% - 3rem);
      margin: 0 auto;
      display: flex;
      align-items: center;
      background: var(--bg-light);
      border-radius: 999px;
      padding: 0.5rem 1rem;
    }
    .search-box .icon { width: 20px; height: 20px; background: var(--text-white) center/contain no-repeat; margin-right: 0.5rem; }
    .search-box .icon-right { width: 20px; height: 20px; background: var(--text-white) center/contain no-repeat; margin-left: auto; }
    .search-box input {
      width: calc(100% - 40px);
      background: transparent;
      border: none;
      color: var(--text-white);
      font-size: 1rem;
      outline: none;
    }
    .actions { display: flex; align-items: center; margin-left: 1rem; }
    .icon-btn { width: 32px; height: 32px; margin-left: 1rem; background: var(--text-white) center/contain no-repeat; cursor: pointer; }

    /* Main */
    .main { grid-area: main; padding: 1.5rem; overflow-y: auto; }
    .genres { display: flex; gap: 1rem; margin-bottom: 2rem; }
    .genre { padding: 0.5rem 1rem; background: var(--bg-light); border-radius: 999px; font-size: 0.9rem; }
    .featured { position: relative; background: var(--bg-light); border-radius: 20px; height: 200px; margin-bottom: 3rem; display: flex; align-items: center; padding: 1.5rem; }
    .featured h2 { font-size: 1.5rem; margin-bottom: 1rem; }
    .buttons { display: flex; gap: 1rem; }
    .btn-play { padding: 0.5rem 1rem; background: var(--accent-red); border: none; border-radius: 4px; color: var(--text-white); cursor: pointer; }
    .btn-fav { width: 32px; height: 32px; background: var(--text-white) center/contain no-repeat; border: none; border-radius: 4px; cursor: pointer; }
    .carousel-controls { position: absolute; right: 1rem; display: flex; gap: 0.5rem; }
    .carousel-controls .icon { width: 32px; height: 32px; background: var(--text-white) center/contain no-repeat; }

    /* Popular */
    .popular-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 1rem; }
    .popular-header h3 { font-size: 1.25rem; }
    .popular-header a { color: var(--text-gray); font-size: 0.9rem; text-decoration: none; }

    .cards {
      display: grid;
      grid-template-columns: repeat(auto-fit, minmax(120px, 1fr));
      gap: 1rem;
    }

    .card-item {
      display: flex;
      flex-direction: column;
      align-items: center;
    }

    .card {
      background: var(--bg-light);
      border-radius: 12px;
      width: 100%;
      padding-bottom: 150%;
      position: relative;
    }

    .card-info {
      margin-top: 0.5rem;
      text-align: center;
      color: var(--text-white);
      font-size: 0.9rem;
    }

    .card-info .rating {
      display: flex;
      justify-content: center;
      color: yellow;
      font-size: 0.8rem;
      margin-top: 0.25rem;
    }

    /* Aside */
    .aside { grid-area: aside; background: var(--bg-light); display: flex; flex-direction: column; padding: 1.5rem; }
    .profile { display: flex; align-items: center; gap: 1rem; margin-bottom: 2rem; }
    .profile img { width: 48px; height: 48px; border-radius: 50%; background: gray; }
    .profile .info div:first-child { font-size: 1rem; color: var(--text-white); }
    .profile .info div:last-child { font-size: 0.8rem; color: var(--text-gray); }
    .recommendations { margin-bottom: 2rem; }
    .recommendations .section-title { margin-bottom: 1rem; }
    .recommendations .list { display: flex; flex-direction: column; gap: 1rem; }
    .recommendations .item { display: flex; align-items: center; gap: 0.75rem; font-size: 0.8rem; }
    .recommendations .item img { width: 40px; height: 40px; background: gray; border-radius: 4px; }
    .recommendations .rating { margin-left: auto; display: flex; align-items: center; color: yellow; font-size: 0.8rem; }
    .btn-all { align-self: flex-start; padding: 0.75rem; background: var(--accent-red); border: none; border-radius: 4px; color: var(--text-white); font-size: 0.9rem; cursor: pointer; }

    /* Responsive */
    @media (max-width: 768px) {
      .container { grid-template-columns: 1fr; grid-template-areas: "header" "main"; }
      .sidebar, .aside { display: none; }
      .header { justify-content: center; }
      .search-box { max-width: 90%; }
    }
    
    section.popular + section.popular {
  margin-top: 55px;
}

/* on remplace le carré blanc par le SVG pour l’item favoris */
.sidebar .nav-group .favoris .icon {
  background: url('Bookmark.svg') center/contain no-repeat;
}

.sidebar .nav-group .categorie .icon {
  background: url('Diversity.svg') center/contain no-repeat;
}

.sidebar .nav-group .àvenir .icon {
  background: url('Group.svg') center/contain no-repeat;
}

.sidebar .nav-group .amis .icon {
  background: url('User Account.svg') center/contain no-repeat;
}

.sidebar .nav-group .groupe .icon {
  background: url('Group-1.svg') center/contain no-repeat;
}

.sidebar .logout-group .logout .icon {
  background: url('Logout.svg') center/contain no-repeat;
}

.header .search-box .icon {
  background: url('Vector-1.svg') center/contain no-repeat;
}

.header .search-box .icon-right {
  background: url('Slider.svg') center/contain no-repeat;
}

.header .actions .icon-btn {
  background: url('Group%205.svg') center/contain no-repeat;
}
  </style>
</head>
<body>
  <div class="container">
    <!-- Sidebar -->
    <aside class="sidebar">
      <div>
        <div class="logo">
          <div class="logo-icon"></div>
          <div class="logo-text">Nouvel Acte</div>
        </div>
        <div class="nav-group">
          <p class="section-title">Menu</p>
          <ul>
              <li class="favoris">
            <div class="icon"></div>Favoris</li>
            <li class="àvenir">
            <div class="icon"></div>À Venir</li>
            <li class="categorie">
            <div class="icon"></div>Catégorie</li>
          </ul>
        </div>
        <div class="nav-group">
          <p class="section-title">Sociale</p>
          <ul>
            <li class="amis"><div class="icon"></div>Amis</li>
            <li class="groupe"><div class="icon"></div>Groupe</li>
          </ul>
        </div>
      </div>
      <div class="logout-group">
        <p class="section-title">Général</p>
        <div class="logout"><div class="icon"></div>Se déconnecter</div>
      </div>
    </aside>

    <!-- Header -->
    <header class="header">
      <div class="search-box">
        <div class="icon"></div>
        <input type="text" placeholder="Rechercher"/>
        <div class="icon-right"></div>
      </div>
      <div class="actions">
        <div class="icon-btn" title="Notifications"></div>
      </div>
    </header>

    <!-- Main content -->
    <main class="main">
      <div class="genres">
        <div class="genre">Genre</div><div class="genre">Genre</div><div class="genre">Genre</div>
        <div class="genre">Genre</div><div class="genre">Genre</div><div class="genre">Genre</div>
      </div>
      <section class="featured">
        <div class="info">
          <h2>Nom du Spectacle</h2>
          <div class="buttons">
            <button class="btn-play">Bande d'annonce</button>
            <button class="btn-fav"></button>
          </div>
        </div>
        <div class="carousel-controls">
          <div class="icon"></div><div class="icon"></div>
        </div>
      </section>
      <section class="popular">
        <div class="popular-header">
          <h3>Spectacle Populaire</h3>
          <a href="#">Voir plus</a>
        </div>
        <div class="cards">
          <div class="card-item">
            <div class="card"></div>
            <div class="card-info">
              <div class="title">Nom du Spectacle</div>
              <div class="rating">★ 7.8 (132)</div>
            </div>
          </div>
          <div class="card-item">
            <div class="card"></div>
            <div class="card-info">
              <div class="title">Nom du Spectacle</div>
              <div class="rating">★ 7.8 (132)</div>
            </div>
          </div>
          <div class="card-item">
            <div class="card"></div>
            <div class="card-info">
              <div class="title">Nom du Spectacle</div>
              <div class="rating">★ 7.8 (132)</div>
            </div>
          </div>
          <div class="card-item">
            <div class="card"></div>
            <div class="card-info">
              <div class="title">Nom du Spectacle</div>
              <div class="rating">★ 7.8 (132)</div>
            </div>
          </div>
          <div class="card-item">
            <div class="card"></div>
            <div class="card-info">
              <div class="title">Nom du Spectacle</div>
              <div class="rating">★ 7.8 (132)</div>
            </div>
          </div>
        </div>
      </section>
      <section class="popular">
        <div class="popular-header">
          <h3>Spectacle Populaire</h3>
          <a href="#">Voir plus</a>
        </div>
        <div class="cards">
          <div class="card-item">
            <div class="card"></div>
            <div class="card-info">
              <div class="title">Nom du Spectacle</div>
              <div class="rating">★ 7.8 (132)</div>
            </div>
          </div>
          <div class="card-item">
            <div class="card"></div>
            <div class="card-info">
              <div class="title">Nom du Spectacle</div>
              <div class="rating">★ 7.8 (132)</div>
            </div>
          </div>
          <div class="card-item">
            <div class="card"></div>
            <div class="card-info">
              <div class="title">Nom du Spectacle</div>
              <div class="rating">★ 7.8 (132)</div>
            </div>
          </div>
          <div class="card-item">
            <div class="card"></div>
            <div class="card-info">
              <div class="title">Nom du Spectacle</div>
              <div class="rating">★ 7.8 (132)</div>
            </div>
          </div>
          <div class="card-item">
            <div class="card"></div>
            <div class="card-info">
              <div class="title">Nom du Spectacle</div>
              <div class="rating">★ 7.8 (132)</div>
            </div>
          </div>
        </div>
      </section>
    </main>

    <!-- Aside recos -->
    <aside class="aside">
      <div class="profile">
        <img src="#" alt="Avatar"/>
        <div class="info"><div>Nom du profil</div><div>@duprofil</div></div>
      </div>
      <div class="recommendations">
        <p class="section-title">Aimer par tes amis</p>
        <div class="list">
          <div class="item"><img src="#" alt=""/><div>Nom du Spectacle</div><div class="rating">★ 7.8 (132)</div></div>
          <div class="item"><img src="#" alt=""/><div>Nom du Spectacle</div><div class="rating">★ 7.8 (132)</div></div>
          <div class="item"><img src="#" alt=""/><div>Nom du Spectacle</div><div class="rating">★ 7.8 (132)</div></div>
          <div class="item"><img src="#" alt=""/><div>Nom du Spectacle</div><div class="rating">★ 7.8 (132)</div></div>
        </div>
      </div>
      <button class="btn-all">Voir tout</button>
    </aside>
  </div>
</body>
</html>
