<!DOCTYPE html>
<html lang="fr">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0"/>
  <title>Nouvel Acte Dashboard</title>
  <style>
    /* Reset & box-sizing */
    * { margin: 0; padding: 0; box-sizing: border-box; }
    html, body { height: 100%; font-family: sans-serif; }

    /* Couleurs */
    :root {
      --bg-dark: #0b0b0b;
      --bg-light: #1f1f1f;
      --accent-red: #E30B17;
      --text-white: #ffffff;
      --text-gray: #7a7a7a;
      --input-bg: #ffffff;
    }
    body { background: var(--bg-dark); color: var(--text-white); }

    /* Grid principal */
    .container {
      display: grid;
      grid-template-columns: 250px 1fr 250px;
      grid-template-areas: "sidebar main aside";
      height: 100vh;
    }

    /* Sidebar gauche (inchangé) */
    .sidebar {
      grid-area: sidebar;
      background: var(--bg-light);
      display: flex;
      flex-direction: column;
      justify-content: space-between;
      padding: 1.5rem;
    }
    .logo { display: flex; align-items: center; margin-bottom: 2.5rem; }
    .logo-icon { width: 24px; height: 24px; background: url('icon.svg') center/contain no-repeat; }
    .logo-text { margin-left: 0.5rem; font-size: 1rem; text-transform: uppercase; font-weight: bold; color: var(--text-white); }
    .section-title { font-size: 0.75rem; text-transform: uppercase; color: var(--text-gray); margin-bottom: 1rem; }
    .nav-group { margin-bottom: 2rem; }
    .nav-group ul { list-style: none; }
    .nav-group li { display: flex; align-items: center; margin: 0.75rem 0; font-size: 0.9rem; cursor: pointer; color: var(--text-white); }
    .nav-group li .icon { width: 20px; height: 20px; background: var(--text-white) center/contain no-repeat; margin-right: 0.5rem; }
    .logout-group { margin-top: 2rem; }
    .logout-group .section-title { margin-bottom: 1rem; }
    .logout { display: flex; align-items: center; font-size: 0.9rem; cursor: pointer; color: var(--text-white); }
    .logout .icon { width: 20px; height: 20px; background: var(--text-white) center/contain no-repeat; margin-right: 0.5rem; }

    /* Section principale : Avis */
    .main {
      grid-area: main;
      background: var(--bg-dark);
      padding: 2rem;
      display: flex;
      flex-direction: column;
    }
    .main h2 {
      font-size: 1.5rem;
      margin-bottom: 1.5rem;
      color: var(--text-white);
    }
    .form-group {
      display: flex;
      flex-direction: column;
      margin-bottom: 1.5rem;
    }
    .form-group label {
      font-size: 0.875rem;
      color: var(--text-white);
      margin-bottom: 0.5rem;
    }
    .form-group textarea {
      width: 100%;
      height: 200px;
      background: var(--input-bg);
      border: none;
      border-radius: 24px;
      padding: 1rem;
      font-size: 1rem;
      resize: none;
    }
    .rating-group {
      display: flex;
      align-items: center;
      gap: 0.5rem;
      margin-bottom: 1rem;
    }
    .rating-group span {
      font-size: 1.5rem;
      color: var(--text-white);
      cursor: pointer;
    }
    .rating-group span.empty { color: var(--text-gray); }
    .rating-group span.filled { color: #FFD700; }
    .btn-send {
      align-self: flex-start;
      padding: 0.75rem 2rem;
      background: var(--accent-red);
      color: var(--text-white);
      font-weight: bold;
      border: none;
      border-radius: 24px;
      cursor: pointer;
    }

    /* Sidebar droite (inchangé) */
    .aside {
      grid-area: aside;
      background: var(--bg-light);
      display: flex;
      flex-direction: column;
      padding: 1.5rem;
    }
    .profile { display: flex; align-items: center; gap: 1rem; margin-bottom: 2rem; }
    .profile img { width: 48px; height: 48px; border-radius: 50%; background: gray; }
    .profile .info div:first-child { font-size: 1rem; color: var(--text-white); }
    .profile .info div:last-child { font-size: 0.8rem; color: var(--text-gray); }
    .recommendations { margin-bottom: 2rem; }
    .recommendations .section-title { margin-bottom: 1rem; }
    .recommendations .list { display: flex; flex-direction: column; gap: 1rem; }
    .recommendations .item { display: flex; align-items: center; gap: 0.75rem; font-size: 0.8rem; }
    .recommendations .item img { width: 40px; height: 40px; background: gray; border-radius: 4px; }
    .recommendations .rating { margin-left: auto; display: flex; align-items: center; color: #FFD700; font-size: 0.8rem; }
    .btn-all { align-self: flex-start; padding: 0.75rem; background: var(--accent-red); border: none; border-radius: 4px; color: var(--text-white); font-size: 0.9rem; cursor: pointer; }

    /* Responsive */
    @media (max-width: 768px) {
      .container { grid-template-columns: 1fr; }
      .sidebar, .aside { display: none; }
    }
  </style>
</head>
<body>
  <div class="container">
    <!-- Sidebar gauche -->
    <aside class="sidebar">
      <div>
        <div class="logo">
          <div class="logo-icon"></div>
          <div class="logo-text">Nouvel Acte</div>
        </div>
        <div class="nav-group">
          <p class="section-title">Menu</p>
          <ul>
            <li class="favoris"><div class="icon"></div>Favoris</li>
            <li class="àvenir"><div class="icon"></div>À Venir</li>
            <li class="categorie"><div class="icon"></div>Catégorie</li>
          </ul>
        </div>
        <div class="nav-group">
          <p class="section-title">Sociale</p>
          <ul>
            <li class="amis"><div class="icon"></div>Amis</li>
            <li class="groupe"><div class="icon"></div>Groupe</li>
          </ul>
        </div>
      </div>
      <div class="logout-group">
        <p class="section-title">Général</p>
        <div class="logout"><div class="icon"></div>Se déconnecter</div>
      </div>
    </aside>

    <!-- Section principale : Avis -->
    <main class="main">
      <h2>Avis</h2>
      <div class="form-group">
        <label for="message">Message</label>
        <textarea id="message" placeholder="Écris ton message..."></textarea>
      </div>
      <div class="form-group">
        <label>Note</label>
        <div class="rating-group">
          <span class="empty">☆</span>
          <span class="empty">☆</span>
          <span class="empty">☆</span>
          <span class="empty">☆</span>
          <span class="empty">☆</span>
        </div>
      </div>
      <button class="btn-send">Envoyer</button>
    </main>

    <!-- Sidebar droite -->
    <aside class="aside">
      <div class="profile">
        <img src="#" alt="Avatar"/>
        <div class="info"><div>Nom du profil</div><div>@duprofil</div></div>
      </div>
      <div class="recommendations">
        <p class="section-title">Aimer par tes amis</p>
        <div class="list">
          <div class="item"><img src="#" alt=""/><div>Nom du Spectacle</div><div class="rating">★ 7.8 (132)</div></div>
          <div class="item"><img src="#" alt=""/><div>Nom du Spectacle</div><div class="rating">★ 7.8 (132)</div></div>
          <div class="item"><img src="#" alt=""/><div>Nom du Spectacle</div><div class="rating">★ 7.8 (132)</div></div>
          <div class="item"><img src="#" alt=""/><div>Nom du Spectacle</div><div class="rating">★ 7.8 (132)</div></div>
        </div>
      </div>
      <button class="btn-all">Voir tout</button>
    </aside>
  </div>
</body>
</html>
