<?php
// Test de connexion avec vos identifiants
$host = 'localhost';
$dbname = 'ilanmolia_SAE202';
$username = 'ilanmolia_molia';
$password = 'Jtd4i08022005#';
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Test de connexion - Nouvel Acte</title>
    <style>
        body { 
            font-family: Arial, sans-serif; 
            max-width: 800px; 
            margin: 20px auto; 
            padding: 20px; 
            background-color: #f5f5f5;
        }
        .container {
            background: white;
            padding: 30px;
            border-radius: 10px;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
        }
        .success { 
            color: green; 
            background: #d4edda; 
            padding: 15px; 
            border-radius: 5px; 
            margin: 10px 0; 
            border-left: 4px solid green; 
        }
        .error { 
            color: red; 
            background: #f8d7da; 
            padding: 15px; 
            border-radius: 5px; 
            margin: 10px 0; 
            border-left: 4px solid red; 
        }
        .info { 
            color: blue; 
            background: #d1ecf1; 
            padding: 15px; 
            border-radius: 5px; 
            margin: 10px 0; 
            border-left: 4px solid blue; 
        }
        .warning { 
            color: orange; 
            background: #fff3cd; 
            padding: 15px; 
            border-radius: 5px; 
            margin: 10px 0; 
            border-left: 4px solid orange; 
        }
        table { 
            width: 100%; 
            border-collapse: collapse; 
            margin: 20px 0; 
        }
        th, td { 
            padding: 10px; 
            text-align: left; 
            border-bottom: 1px solid #ddd; 
        }
        th { 
            background-color: #f2f2f2; 
        }
        .code { 
            background: #f8f9fa; 
            padding: 10px; 
            border-radius: 3px; 
            font-family: monospace; 
        }
        h1 { color: #333; }
        h2 { color: #666; border-bottom: 2px solid #eee; padding-bottom: 10px; }
    </style>
</head>
<body>
    <div class="container">
        <h1>🎭 Test de connexion - Nouvel Acte</h1>
        <p><em>Test effectué le : <?php echo date('d/m/Y à H:i:s'); ?></em></p>

        <h2>1. Vérification des prérequis PHP</h2>
        
        <?php
        $phpVersion = PHP_VERSION;
        echo "<div class='info'><strong>Version PHP :</strong> $phpVersion</div>";

        if (version_compare($phpVersion, '8.0', '>=')) {
            echo "<div class='success'>✅ Version PHP compatible (8.0+)</div>";
        } else {
            echo "<div class='error'>❌ Version PHP trop ancienne. Requis : 8.0+</div>";
        }

        $extensions = [
            'pdo' => 'PDO (base)',
            'pdo_mysql' => 'PDO MySQL',
            'json' => 'JSON',
            'mbstring' => 'Multibyte String',
            'mysqli' => 'MySQLi'
        ];

        echo "<h3>Extensions PHP :</h3>";
        foreach ($extensions as $ext => $description) {
            if (extension_loaded($ext)) {
                echo "<div class='success'>✅ $description ($ext)</div>";
            } else {
                echo "<div class='error'>❌ $description ($ext) - MANQUANTE</div>";
            }
        }
        ?>

        <h2>2. Test de connexion PDO (utilisé par l'application)</h2>

        <?php
        try {
            $dsn = "mysql:host=$host;dbname=$dbname;charset=utf8mb4";
            $pdo = new PDO($dsn, $username, $password, [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false,
            ]);
            
            echo "<div class='success'>✅ Connexion PDO réussie !</div>";
            
            // Informations sur la base de données
            $stmt = $pdo->query("SELECT VERSION() as version");
            $version = $stmt->fetch();
            echo "<div class='info'><strong>Version MySQL/MariaDB :</strong> " . $version['version'] . "</div>";
            
            // Test d'une requête simple
            $stmt = $pdo->query("SELECT COUNT(*) as count FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '$dbname'");
            $result = $stmt->fetch();
            echo "<div class='info'><strong>Nombre de tables dans la base :</strong> " . $result['count'] . "</div>";
            
            // Vérification des tables nécessaires
            echo "<h3>Vérification des tables :</h3>";
            $requiredTables = ['users', 'roles', 'performances', 'categories', 'schedules', 'reservations', 'halls'];
            
            foreach ($requiredTables as $table) {
                $stmt = $pdo->query("SHOW TABLES LIKE '$table'");
                if ($stmt->rowCount() > 0) {
                    // Compter les enregistrements
                    $stmt = $pdo->query("SELECT COUNT(*) as count FROM `$table`");
                    $count = $stmt->fetch();
                    echo "<div class='success'>✅ Table '$table' existe (" . $count['count'] . " enregistrements)</div>";
                } else {
                    echo "<div class='error'>❌ Table '$table' manquante</div>";
                }
            }
            
        } catch (PDOException $e) {
            echo "<div class='error'>❌ Erreur PDO : " . $e->getMessage() . "</div>";
            echo "<div class='warning'>⚠️ Vérifiez vos identifiants de connexion dans le code</div>";
        }
        ?>

        <h2>3. Test de connexion MySQLi (votre méthode actuelle)</h2>

        <?php
        $link = mysqli_connect($host, $username, $password, $dbname);

        if ($link) {
            echo "<div class='success'>✅ Connexion MySQLi réussie !</div>";
            
            // Test d'une requête
            $result = mysqli_query($link, "SELECT COUNT(*) as count FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_SCHEMA = '$dbname'");
            if ($result) {
                $row = mysqli_fetch_assoc($result);
                echo "<div class='info'><strong>Tables détectées via MySQLi :</strong> " . $row['count'] . "</div>";
            }
            
            mysqli_close($link);
        } else {
            echo "<div class='error'>❌ Erreur MySQLi : " . mysqli_connect_error() . "</div>";
        }
        ?>

        <h2>4. Configuration détectée</h2>
        <table>
            <tr><th>Paramètre</th><th>Valeur</th></tr>
            <tr><td>Host</td><td><?php echo $host; ?></td></tr>
            <tr><td>Base de données</td><td><?php echo $dbname; ?></td></tr>
            <tr><td>Utilisateur</td><td><?php echo $username; ?></td></tr>
            <tr><td>Version PHP</td><td><?php echo PHP_VERSION; ?></td></tr>
            <tr><td>Système</td><td><?php echo PHP_OS; ?></td></tr>
            <tr><td>Serveur Web</td><td><?php echo $_SERVER['SERVER_SOFTWARE'] ?? 'Non détecté'; ?></td></tr>
        </table>

        <h2>5. Test des permissions de fichiers</h2>

        <?php
        $directories = [
            'storage' => 'Dossier de stockage',
            'storage/logs' => 'Logs d\'erreur',
            'storage/uploads' => 'Fichiers uploadés'
        ];

        foreach ($directories as $dir => $description) {
            if (!is_dir($dir)) {
                if (mkdir($dir, 0755, true)) {
                    echo "<div class='success'>✅ Dossier '$dir' créé ($description)</div>";
                } else {
                    echo "<div class='error'>❌ Impossible de créer le dossier '$dir'</div>";
                }
            } else {
                echo "<div class='success'>✅ Dossier '$dir' existe ($description)</div>";
            }
            
            if (is_dir($dir) && is_writable($dir)) {
                echo "<div class='success'>✅ Dossier '$dir' accessible en écriture</div>";
            } else {
                echo "<div class='error'>❌ Dossier '$dir' non accessible en écriture</div>";
            }
        }
        ?>

        <h2>6. Prochaines étapes</h2>

        <?php if (isset($pdo)): ?>
            <div class="success">
                <h3>✅ Connexion réussie ! Prochaines étapes :</h3>
                <ol>
                    <li><strong>Supprimez ce fichier</strong> (test_connection.php) pour la sécurité</li>
                    <li><strong>Importez le schéma SQL</strong> dans phpMyAdmin si pas encore fait</li>
                    <li><strong>Accédez à votre application :</strong>
                        <ul>
                            <li>Page d'accueil : <a href="./">http://votre-domaine/</a></li>
                            <li>Interface admin : <a href="./admin">http://votre-domaine/admin</a></li>
                        </ul>
                    </li>
                    <li><strong>Créez un compte administrateur</strong> via l'interface ou la base de données</li>
                </ol>
            </div>
        <?php else: ?>
            <div class="error">
                <h3>❌ Problème de connexion</h3>
                <p>Vérifiez :</p>
                <ul>
                    <li>Que la base de données 'ilanmolia_SAE202' existe</li>
                    <li>Que l'utilisateur 'ilanmolia_molia' a les bonnes permissions</li>
                    <li>Que le mot de passe est correct</li>
                    <li>Que MySQL/MariaDB est démarré</li>
                </ul>
            </div>
        <?php endif; ?>

        <div class="warning">
            <h3>⚠️ Sécurité importante</h3>
            <p><strong>Supprimez ce fichier après le test</strong> car il contient vos identifiants de base de données !</p>
            <div class="code">rm test_connection.php</div>
        </div>

        <script>
            // JavaScript pour améliorer l'expérience utilisateur
            document.addEventListener('DOMContentLoaded', function() {
                // Ajouter un effet de fade-in
                document.body.style.opacity = '0';
                document.body.style.transition = 'opacity 0.5s';
                setTimeout(function() {
                    document.body.style.opacity = '1';
                }, 100);
                
                // Ajouter un bouton pour supprimer le fichier (simulation)
                const warningDiv = document.querySelector('.warning');
                if (warningDiv) {
                    const button = document.createElement('button');
                    button.textContent = 'Marquer comme lu';
                    button.style.marginTop = '10px';
                    button.style.padding = '10px 20px';
                    button.style.backgroundColor = '#dc3545';
                    button.style.color = 'white';
                    button.style.border = 'none';
                    button.style.borderRadius = '5px';
                    button.style.cursor = 'pointer';
                    
                    button.onclick = function() {
                        alert('N\'oubliez pas de supprimer ce fichier manuellement !');
                        this.style.backgroundColor = '#28a745';
                        this.textContent = '✅ Lu et compris';
                        this.disabled = true;
                    };
                    
                    warningDiv.appendChild(button);
                }
            });
        </script>
    </div>
</body>
</html>
