<?php
// Script pour ajouter des données de test supplémentaires
require_once __DIR__ . '/../config/cpanel_bootstrap.php';

try {
    $pdo = \App\Core\CpanelDatabase::getInstance();
    
    echo "<h1>Ajout de données de test</h1>";
    
    // Ajouter plus d'utilisateurs de test
    $users = [
        ['marie.martin@email.com', 'Marie Martin', 'Marie', 'Martin'],
        ['pierre.durand@email.com', 'Pierre Durand', 'Pierre', 'Durand'],
        ['sophie.bernard@email.com', 'Sophie Bernard', 'Sophie', 'Bernard'],
        ['lucas.petit@email.com', 'Lucas Petit', 'Lucas', 'Petit'],
        ['emma.robert@email.com', 'Emma Robert', 'Emma', 'Robert']
    ];
    
    $stmt = $pdo->prepare("INSERT INTO users (email, password_hash, display_name, first_name, last_name, role_id, email_verified_at) VALUES (?, ?, ?, ?, ?, 4, NOW())");
    
    foreach ($users as $user) {
        $stmt->execute([
            $user[0],
            password_hash('password123', PASSWORD_DEFAULT),
            $user[1],
            $user[2],
            $user[3]
        ]);
    }
    
    echo "<p>✅ Utilisateurs de test ajoutés</p>";
    
    // Ajouter des réservations de test
    $reservations = [
        [4, 2, 120.00, 0.00, 120.00, 'paid'],
        [5, 3, 100.00, 15.00, 85.00, 'paid'],
        [6, 1, 90.00, 0.00, 90.00, 'confirmed'],
        [7, 4, 64.00, 6.40, 57.60, 'paid']
    ];
    
    $stmt = $pdo->prepare("INSERT INTO reservations (user_id, schedule_id, total_price, discount_amount, final_price, status) VALUES (?, ?, ?, ?, ?, ?)");
    
    foreach ($reservations as $i => $reservation) {
        $stmt->execute($reservation);
        $reservationId = $pdo->lastInsertId();
        
        // Ajouter les items de réservation
        $pdo->prepare("INSERT INTO reservation_items (reservation_id, schedule_id, quantity, unit_price, total_price) VALUES (?, ?, 2, ?, ?)")
            ->execute([$reservationId, $reservation[1], $reservation[2]/2, $reservation[2]]);
    }
    
    echo "<p>✅ Réservations de test ajoutées</p>";
    
    // Ajouter des avis supplémentaires
    $reviews = [
        [4, 1, 4, 'Très bon spectacle', 'Belle interprétation moderne de ce classique.'],
        [5, 2, 5, 'Époustouflant !', 'J\'ai été transporté du début à la fin. Magnifique !'],
        [6, 3, 5, 'Parfait pour les enfants', 'Mes enfants ont adoré, et moi aussi !'],
        [7, 5, 3, 'Correct sans plus', 'Quelques bons moments mais dans l\'ensemble décevant.']
    ];
    
    $stmt = $pdo->prepare("INSERT INTO reviews (user_id, performance_id, rating, title, comment, is_approved) VALUES (?, ?, ?, ?, ?, TRUE)");
    
    foreach ($reviews as $review) {
        $stmt->execute($review);
    }
    
    echo "<p>✅ Avis de test ajoutés</p>";
    
    echo "<h2>Résumé de la base de données :</h2>";
    
    // Statistiques
    $stats = [
        'Utilisateurs' => $pdo->query("SELECT COUNT(*) FROM users")->fetchColumn(),
        'Spectacles' => $pdo->query("SELECT COUNT(*) FROM performances")->fetchColumn(),
        'Séances' => $pdo->query("SELECT COUNT(*) FROM schedules")->fetchColumn(),
        'Réservations' => $pdo->query("SELECT COUNT(*) FROM reservations")->fetchColumn(),
        'Avis' => $pdo->query("SELECT COUNT(*) FROM reviews")->fetchColumn(),
        'Catégories' => $pdo->query("SELECT COUNT(*) FROM categories")->fetchColumn()
    ];
    
    foreach ($stats as $label => $count) {
        echo "<p><strong>$label :</strong> $count</p>";
    }
    
    echo "<h3>Comptes de test :</h3>";
    echo "<ul>";
    echo "<li><strong>Admin :</strong> admin@nouvelacte.fr / password</li>";
    echo "<li><strong>Manager :</strong> manager@nouvelacte.fr / password</li>";
    echo "<li><strong>Client :</strong> client@nouvelacte.fr / password</li>";
    echo "</ul>";
    
    echo "<p><em>Mot de passe par défaut pour tous les comptes : password</em></p>";
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Erreur : " . $e->getMessage() . "</p>";
}
?>