<?php
declare(strict_types=1);

// Bootstrap adapté pour cPanel
require_once __DIR__ . '/database.php';

// Démarrage de la session en premier
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

// Initialiser $_SESSION si elle n'existe pas
if (!isset($_SESSION)) {
    $_SESSION = [];
}

// Configuration des erreurs selon l'environnement
if (DatabaseConfig::APP_DEBUG) {
    error_reporting(E_ALL);
    ini_set('display_errors', '1');
} else {
    error_reporting(0);
    ini_set('display_errors', '0');
    ini_set('log_errors', '1');
    ini_set('error_log', __DIR__ . '/../storage/logs/error.log');
}

// Création du dossier de logs s'il n'existe pas
$logDir = __DIR__ . '/../storage/logs';
if (!is_dir($logDir)) {
    mkdir($logDir, 0755, true);
}

// Configuration de la session
ini_set('session.cookie_httponly', '1');
ini_set('session.cookie_secure', '0'); // Mettre à 1 si HTTPS
ini_set('session.use_strict_mode', '1');

// Autoloader simple pour cPanel
spl_autoload_register(function ($class) {
    $prefix = 'App\\';
    $base_dir = __DIR__ . '/../app/';
    
    $len = strlen($prefix);
    if (strncmp($prefix, $class, $len) !== 0) {
        return;
    }
    
    $relative_class = substr($class, $len);
    $file = $base_dir . str_replace('\\', '/', $relative_class) . '.php';
    
    if (file_exists($file)) {
        require $file;
    }
});

// Fonction helper pour les chemins
function app_path(string $path = ''): string {
    return __DIR__ . '/../app/' . ltrim($path, '/');
}

function storage_path(string $path = ''): string {
    return __DIR__ . '/../storage/' . ltrim($path, '/');
}

function public_path(string $path = ''): string {
    return __DIR__ . '/../public/' . ltrim($path, '/');
}

// Définir les constantes pour compatibilité
define('APP_DEBUG', DatabaseConfig::APP_DEBUG);
?>
