<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= isset($title) ? htmlspecialchars($title) : 'Nouvel Acte' ?></title>
    <style>
        /* Reset & box-sizing */
        * { margin: 0; padding: 0; box-sizing: border-box; }
        html, body { height: 100%; font-family: sans-serif; }

        /* Couleurs */
        :root {
            --bg-dark: #0b0b0b;
            --bg-light: #1f1f1f;
            --accent-red: #E30B17;
            --text-white: #ffffff;
            --text-gray: #7a7a7a;
        }
        body { background: var(--bg-dark); color: var(--text-white); }

        /* Grid principal */
        .container {
            display: grid;
            grid-template-columns: 250px 1fr 250px;
            grid-template-rows: 60px 1fr;
            grid-template-areas:
                "sidebar header aside"
                "sidebar main aside";
            height: 100vh;
        }

        /* Sidebar */
        .sidebar {
            grid-area: sidebar;
            background: var(--bg-light);
            display: flex;
            flex-direction: column;
            justify-content: space-between;
            padding: 1.5rem;
        }
        .logo { display: flex; align-items: center; margin-bottom: 2.5rem; }
        .logo-text { margin-left: 0.5rem; font-size: 1rem; text-transform: uppercase; font-weight: bold; }
        .section-title { font-size: 0.75rem; text-transform: uppercase; color: var(--text-gray); margin-bottom: 1rem; }
        .nav-group { margin-bottom: 2rem; }
        .nav-group ul { list-style: none; }
        .nav-group li { display: flex; align-items: center; margin: 0.75rem 0; font-size: 0.9rem; cursor: pointer; }
        .nav-group li a { color: var(--text-white); text-decoration: none; }

        /* Header */
        .header {
            grid-area: header;
            display: flex;
            align-items: center;
            justify-content: center;
            background: var(--bg-dark);
            padding: 0 1.5rem;
        }
        .search-box {
            width: 600px;
            max-width: calc(100% - 3rem);
            display: flex;
            align-items: center;
            background: var(--bg-light);
            border-radius: 999px;
            padding: 0.5rem 1rem;
        }
        .search-box input {
            width: 100%;
            background: transparent;
            border: none;
            color: var(--text-white);
            font-size: 1rem;
            outline: none;
        }

        /* Main */
        .main { grid-area: main; padding: 1.5rem; overflow-y: auto; }

        /* Aside */
        .aside { grid-area: aside; background: var(--bg-light); padding: 1.5rem; }

        /* Responsive */
        @media (max-width: 768px) {
            .container { grid-template-columns: 1fr; grid-template-areas: "header" "main"; }
            .sidebar, .aside { display: none; }
        }
        
        .error-message {
            background: #f8d7da;
            color: #721c24;
            padding: 1rem;
            border-radius: 4px;
            margin: 1rem 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div>
                <div class="logo">
                    <div class="logo-text">Nouvel Acte</div>
                </div>
                <div class="nav-group">
                    <p class="section-title">Menu</p>
                    <ul>
                        <li><a href="/SAE202_danslebon/public/dashboard">Tableau de bord</a></li>
                        <li><a href="/SAE202_danslebon/public/performances">Spectacles</a></li>
                        <li><a href="/SAE202_danslebon/public/reviews">Avis</a></li>
                    </ul>
                </div>
                <div class="nav-group">
                    <p class="section-title">Sociale</p>
                    <ul>
                        <li><a href="/SAE202_danslebon/public/friends">Amis</a></li>
                        <li><a href="/SAE202_danslebon/public/groups">Groupes</a></li>
                    </ul>
                </div>
            </div>
            <div>
                <p class="section-title">Général</p>
                <div><a href="/SAE202_danslebon/public/logout" style="color: var(--text-white); text-decoration: none;">Se déconnecter</a></div>
            </div>
        </aside>

        <!-- Header -->
        <header class="header">
            <div class="search-box">
                <input type="text" placeholder="Rechercher"/>
            </div>
        </header>

        <!-- Main content -->
        <main class="main">
            <?php if (isset($content) && !empty($content)): ?>
                <?= $content ?>
            <?php else: ?>
                <div class="error-message">
                    <h3>Contenu non disponible</h3>
                    <p>Le contenu de cette page n'a pas pu être chargé.</p>
                </div>
            <?php endif; ?>
        </main>

        <!-- Aside -->
        <aside class="aside">
            <div class="profile">
                <div class="info">
                    <?php if (isset($_SESSION['user']) && is_array($_SESSION['user'])): ?>
                        <div><?= htmlspecialchars($_SESSION['user']['display_name'] ?? 'Utilisateur') ?></div>
                        <div>@<?= strtolower(str_replace(' ', '', $_SESSION['user']['display_name'] ?? 'user')) ?></div>
                    <?php else: ?>
                        <div>Visiteur</div>
                        <div><a href="/SAE202_danslebon/public/login" style="color: var(--text-white);">Se connecter</a></div>
                    <?php endif; ?>
                </div>
            </div>
        </aside>
    </div>
</body>
</html>
