<div style="padding: 2rem;">
    <h1>Bienvenue sur Nouvel Acte</h1>
    
    <?php if (isset($featured) && !empty($featured)): ?>
        <section style="margin: 2rem 0;">
            <h2>Spectacles à l'affiche</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 1rem; margin-top: 1rem;">
                <?php foreach ($featured as $performance): ?>
                    <div style="background: #1f1f1f; padding: 1rem; border-radius: 8px;">
                        <h3><?= htmlspecialchars($performance['title'] ?? 'Titre non disponible') ?></h3>
                        <p><?= htmlspecialchars(substr($performance['description'] ?? '', 0, 100)) ?>...</p>
                        <p><strong>Catégorie:</strong> <?= htmlspecialchars($performance['category_name'] ?? 'Non définie') ?></p>
                        <?php if (isset($performance['avg_rating']) && $performance['avg_rating']): ?>
                            <p><strong>Note:</strong> <?= number_format($performance['avg_rating'], 1) ?>/5</p>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
    <?php endif; ?>
    
    <?php if (isset($popular) && !empty($popular)): ?>
        <section style="margin: 2rem 0;">
            <h2>Spectacles populaires</h2>
            <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 1rem; margin-top: 1rem;">
                <?php foreach ($popular as $performance): ?>
                    <div style="background: #1f1f1f; padding: 1rem; border-radius: 8px;">
                        <h3><?= htmlspecialchars($performance['title'] ?? 'Titre non disponible') ?></h3>
                        <p><?= htmlspecialchars(substr($performance['description'] ?? '', 0, 100)) ?>...</p>
                        <p><strong>Catégorie:</strong> <?= htmlspecialchars($performance['category_name'] ?? 'Non définie') ?></p>
                        <?php if (isset($performance['avg_rating']) && $performance['avg_rating']): ?>
                            <p><strong>Note:</strong> <?= number_format($performance['avg_rating'], 1) ?>/5</p>
                        <?php endif; ?>
                    </div>
                <?php endforeach; ?>
            </div>
        </section>
    <?php else: ?>
        <section style="margin: 2rem 0;">
            <h2>Aucun spectacle disponible</h2>
            <p>Il n'y a actuellement aucun spectacle en ligne. Revenez bientôt !</p>
        </section>
    <?php endif; ?>
</div>
