<div class="stats-grid">
    <div class="stat-card">
        <div class="stat-value"><?= number_format($today_sales ?? 0) ?>€</div>
        <div class="stat-label">Ventes du jour</div>
    </div>
    <div class="stat-card">
        <div class="stat-value"><?= number_format($total_revenue ?? 0) ?>€</div>
        <div class="stat-label">Chiffre d'affaires total</div>
    </div>
    <div class="stat-card">
        <div class="stat-value"><?= $pending_reviews ?? 0 ?></div>
        <div class="stat-label">Avis en attente</div>
    </div>
    <div class="stat-card">
        <div class="stat-value"><?= $active_performances ?? 0 ?></div>
        <div class="stat-label">Spectacles actifs</div>
    </div>
</div>

<div class="card">
    <h3>Réservations récentes</h3>
    <table>
        <thead>
            <tr>
                <th>ID</th>
                <th>Client</th>
                <th>Spectacle</th>
                <th>Montant</th>
                <th>Statut</th>
                <th>Date</th>
            </tr>
        </thead>
        <tbody>
            <?php if (!empty($recent_reservations)): ?>
                <?php foreach ($recent_reservations as $reservation): ?>
                    <tr>
                        <td>#<?= $reservation['id'] ?></td>
                        <td><?= htmlspecialchars($reservation['user_name'] ?? 'N/A') ?></td>
                        <td><?= htmlspecialchars($reservation['performance_title'] ?? 'N/A') ?></td>
                        <td><?= number_format($reservation['total_price'], 2) ?>€</td>
                        <td>
                            <span class="status-badge status-<?= $reservation['status'] ?>">
                                <?= ucfirst($reservation['status']) ?>
                            </span>
                        </td>
                        <td><?= date('d/m/Y H:i', strtotime($reservation['booked_at'])) ?></td>
                    </tr>
                <?php endforeach; ?>
            <?php else: ?>
                <tr>
                    <td colspan="6" style="text-align: center; color: #666;">Aucune réservation récente</td>
                </tr>
            <?php endif; ?>
        </tbody>
    </table>
</div>
