<?php
declare(strict_types=1);

namespace App\Models;

use App\Core\CpanelDatabase;
use PDO;

class CpanelUser
{
    private PDO $db;
    
    public function __construct()
    {
        $this->db = CpanelDatabase::getInstance();
    }
    
    public function findByEmail(string $email): ?array
    {
        try {
            $stmt = $this->db->prepare('
                SELECT u.*, r.name as role_name 
                FROM users u 
                JOIN roles r ON u.role_id = r.id 
                WHERE u.email = ?
            ');
            $stmt->execute([$email]);
            
            $user = $stmt->fetch();
            return $user ?: null;
        } catch (\PDOException $e) {
            error_log('Erreur findByEmail: ' . $e->getMessage());
            return null;
        }
    }
    
    public function findById(int $id): ?array
    {
        try {
            $stmt = $this->db->prepare('
                SELECT u.*, r.name as role_name 
                FROM users u 
                JOIN roles r ON u.role_id = r.id 
                WHERE u.id = ?
            ');
            $stmt->execute([$id]);
            
            $user = $stmt->fetch();
            return $user ?: null;
        } catch (\PDOException $e) {
            error_log('Erreur findById: ' . $e->getMessage());
            return null;
        }
    }
    
    public function create(array $data): ?int
    {
        try {
            $stmt = $this->db->prepare('
                INSERT INTO users (email, password_hash, display_name, role_id, created_at) 
                VALUES (?, ?, ?, ?, NOW())
            ');
            
            $result = $stmt->execute([
                $data['email'],
                $data['password_hash'],
                $data['display_name'],
                $data['role_id']
            ]);
            
            return $result ? (int) $this->db->lastInsertId() : null;
        } catch (\PDOException $e) {
            error_log('Erreur create user: ' . $e->getMessage());
            return null;
        }
    }
    
    public function getAll(int $limit = 50, int $offset = 0): array
    {
        try {
            $stmt = $this->db->prepare('
                SELECT u.*, r.name as role_name 
                FROM users u 
                JOIN roles r ON u.role_id = r.id 
                ORDER BY u.created_at DESC 
                LIMIT ? OFFSET ?
            ');
            $stmt->execute([$limit, $offset]);
            
            return $stmt->fetchAll();
        } catch (\PDOException $e) {
            error_log('Erreur getAll users: ' . $e->getMessage());
            return [];
        }
    }
}
?>
