<?php
declare(strict_types=1);

namespace App\Core;

class View
{
    private static string $viewPath = '';
    
    public static function init(): void
    {
        self::$viewPath = __DIR__ . '/../Views/';
    }
    
    public static function render(string $template, array $data = []): string
    {
        if (empty(self::$viewPath)) {
            self::init();
        }
        
        // Extraire les variables pour les rendre disponibles dans la vue
        extract($data);
        
        ob_start();
        $templateFile = self::$viewPath . $template . '.php';
        
        if (!file_exists($templateFile)) {
            throw new \Exception("Template $template non trouvé dans " . $templateFile);
        }
        
        include $templateFile;
        return ob_get_clean();
    }
    
    public static function renderWithLayout(string $template, array $data = [], string $layout = 'layout'): string
    {
        try {
            $content = self::render($template, $data);
            return self::render($layout, array_merge($data, ['content' => $content]));
        } catch (\Exception $e) {
            // En cas d'erreur, retourner un message d'erreur formaté
            return self::renderError($e->getMessage(), $data);
        }
    }
    
    private static function renderError(string $message, array $data = []): string
    {
        $errorContent = "<div class='error-message'>";
        $errorContent .= "<h3>Erreur de rendu</h3>";
        $errorContent .= "<p>" . htmlspecialchars($message) . "</p>";
        $errorContent .= "</div>";
        
        try {
            return self::render('layout', array_merge($data, ['content' => $errorContent]));
        } catch (\Exception $e) {
            // Si même le layout échoue, retourner du HTML simple
            return "<!DOCTYPE html><html><head><title>Erreur</title></head><body>$errorContent</body></html>";
        }
    }
}
?>
