<?php
declare(strict_types=1);

namespace App\Core;

use PDO;
use PDOException;

class CpanelDatabase
{
    private static ?PDO $instance = null;
    
    public static function getInstance(): PDO
    {
        if (self::$instance === null) {
            try {
                $dsn = sprintf(
                    'mysql:host=%s;dbname=%s;charset=%s',
                    'localhost',
                    'ilanmolia_SAE202',
                    'utf8mb4'
                );
                
                self::$instance = new PDO($dsn, 'ilanmolia_molia', 'Jtd4i08022005#', [
                    PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                    PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                    PDO::ATTR_EMULATE_PREPARES => false,
                    PDO::MYSQL_ATTR_INIT_COMMAND => "SET NAMES utf8mb4"
                ]);
                
            } catch (PDOException $e) {
                // Log l'erreur au lieu de l'afficher en production
                error_log('Erreur de connexion à la base de données: ' . $e->getMessage());
                
                if (defined('APP_DEBUG') && APP_DEBUG) {
                    throw new \Exception('Erreur de connexion à la base de données: ' . $e->getMessage());
                } else {
                    throw new \Exception('Erreur de connexion à la base de données. Veuillez réessayer plus tard.');
                }
            }
        }
        
        return self::$instance;
    }
    
    /**
     * Test de connexion pour vérifier la configuration
     */
    public static function testConnection(): bool
    {
        try {
            $pdo = self::getInstance();
            $pdo->query('SELECT 1');
            return true;
        } catch (\Exception $e) {
            error_log('Test de connexion échoué: ' . $e->getMessage());
            return false;
        }
    }
}
?>
