<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Request;
use App\Core\Response;
use App\Core\View;
use App\Models\Performance;

class HomeController
{
    public function index(Request $request): Response
    {
        $performanceModel = new Performance();
        $featuredPerformances = $performanceModel->getFeatured(5);
        $popularPerformances = $performanceModel->getPopular(10);
        
        $content = View::render('home/index', [
            'featured' => $featuredPerformances,
            'popular' => $popularPerformances
        ]);
        
        return new Response($content);
    }
}
?>
