<?php
declare(strict_types=1);

namespace App\Controllers;

use App\Core\Request;
use App\Core\Response;
use App\Core\View;
use App\Models\User;

class AuthController
{
    public function showLogin(Request $request): Response
    {
        if (isset($_SESSION['user'])) {
            return Response::redirect('/dashboard');
        }
        
        $content = View::render('auth/login');
        return new Response($content);
    }
    
    public function login(Request $request): Response
    {
        $email = $request->post('email');
        $password = $request->post('password');
        
        if (!$email || !$password) {
            $content = View::render('auth/login', ['error' => 'Email et mot de passe requis']);
            return new Response($content);
        }
        
        $userModel = new User();
        $user = $userModel->findByEmail($email);
        
        if ($user && password_verify($password, $user['password_hash'])) {
            $_SESSION['user'] = [
                'id' => $user['id'],
                'email' => $user['email'],
                'display_name' => $user['display_name'],
                'role' => $user['role_name']
            ];
            
            $redirectUrl = $user['role_name'] === 'admin' ? '/admin' : '/dashboard';
            return Response::redirect($redirectUrl);
        }
        
        $content = View::render('auth/login', ['error' => 'Identifiants incorrects']);
        return new Response($content);
    }
    
    public function showRegister(Request $request): Response
    {
        $content = View::render('auth/register');
        return new Response($content);
    }
    
    public function register(Request $request): Response
    {
        $email = $request->post('email');
        $password = $request->post('password');
        $displayName = $request->post('display_name');
        
        if (!$email || !$password || !$displayName) {
            $content = View::render('auth/register', ['error' => 'Tous les champs sont requis']);
            return new Response($content);
        }
        
        $userModel = new User();
        
        if ($userModel->findByEmail($email)) {
            $content = View::render('auth/register', ['error' => 'Cet email est déjà utilisé']);
            return new Response($content);
        }
        
        $userId = $userModel->create([
            'email' => $email,
            'password_hash' => password_hash($password, PASSWORD_ARGON2ID),
            'display_name' => $displayName,
            'role_id' => 4 // Client par défaut
        ]);
        
        if ($userId) {
            return Response::redirect('/login?registered=1');
        }
        
        $content = View::render('auth/register', ['error' => 'Erreur lors de l\'inscription']);
        return new Response($content);
    }
    
    public function logout(Request $request): Response
    {
        session_destroy();
        return Response::redirect('/');
    }
}
?>
