<?php
declare(strict_types=1);

namespace App\Controllers\Admin;

use App\Core\Request;
use App\Core\Response;
use App\Core\View;
use App\Models\Reservation;
use App\Models\Performance;
use App\Models\Review;

class DashboardController
{
    public function index(Request $request): Response
    {
        $reservationModel = new Reservation();
        $performanceModel = new Performance();
        $reviewModel = new Review();
        
        $stats = [
            'today_sales' => $reservationModel->getTodaySales(),
            'total_revenue' => $reservationModel->getTotalRevenue(),
            'pending_reviews' => $reviewModel->getPendingCount(),
            'active_performances' => $performanceModel->getActiveCount(),
            'recent_reservations' => $reservationModel->getRecent(10)
        ];
        
        $content = View::renderWithLayout('admin/dashboard', $stats, 'admin/layout');
        return new Response($content);
    }
}
?>
