# 🎭 Installation Nouvel Acte sur cPanel

## Prérequis

- **Hébergement web** avec cPanel
- **PHP 8.0+** (vérifiez dans cPanel > Sélecteur PHP)
- **MySQL 5.7+** ou **MariaDB 10.3+**
- **Extension PHP** : PDO, PDO_MySQL, JSON, MBString

## 📋 Étapes d'installation

### 1. Préparation de la base de données

Dans **cPanel > Bases de données MySQL** :

\`\`\`sql
1. Créez une nouvelle base de données :
   Nom : votre_nom_base

2. Créez un utilisateur :
   Nom : votre_utilisateur
   Mot de passe : votre_mot_de_passe_securise

3. Assignez l'utilisateur à la base avec TOUS les privilèges
\`\`\`

### 2. Import du schéma de base de données

Dans **cPanel > phpMyAdmin** :
1. Sélectionnez votre base de données
2. Onglet "Importer"
3. Uploadez le fichier `database/schema.sql`
4. Cliquez sur "Exécuter"

### 3. Configuration de l'application

Éditez le fichier `config/database.php` :

\`\`\`php
public const DB_HOST = 'localhost'; // ou l'adresse fournie par votre hébergeur
public const DB_NAME = 'votre_nom_base'; // nom de votre base
public const DB_USER = 'votre_utilisateur'; // utilisateur de la base
public const DB_PASS = 'votre_mot_de_passe'; // mot de passe
\`\`\`

### 4. Upload des fichiers

Dans **cPanel > Gestionnaire de fichiers** :

1. **Supprimez** le contenu de `public_html/`
2. **Uploadez** tous les fichiers du projet dans `public_html/`
3. **Déplacez** le contenu du dossier `public/` vers la racine `public_html/`
4. **Ajustez** la structure :

\`\`\`
public_html/
├── index.php (depuis public/)
├── .htaccess (depuis public/)
├── app/
├── config/
├── storage/
├── install/
└── database/
\`\`\`

### 5. Configuration des permissions

Dans le **Gestionnaire de fichiers** :
- **Dossiers** : 755 (clic droit > Permissions)
- **Fichiers** : 644
- **Dossier storage/** : 755 (écriture requise)

### 6. Exécution de l'installateur

1. Accédez à : `https://votre-domaine.com/install/cpanel_installer.php`
2. Suivez les instructions à l'écran
3. **Supprimez** le dossier `install/` après installation

### 7. Configuration SSL (Recommandé)

Dans **cPanel > SSL/TLS** :
1. Activez "Force HTTPS Redirect"
2. Installez un certificat SSL (Let's Encrypt gratuit)

## 🔧 Configuration avancée

### Variables d'environnement

Créez un fichier `.env` dans la racine :

\`\`\`env
APP_ENV=production
APP_DEBUG=false
APP_URL=https://votre-domaine.com

DB_HOST=localhost
DB_NAME=votre_nom_base
DB_USER=votre_utilisateur
DB_PASS=votre_mot_de_passe

JWT_SECRET=votre-cle-secrete-tres-longue-et-complexe
\`\`\`

### Tâches CRON (Optionnel)

Dans **cPanel > Tâches CRON**, ajoutez :

\`\`\`bash
# Nettoyage des logs (quotidien à 2h)
0 2 * * * /usr/bin/php /home/votre_compte/public_html/app/Console/cleanup.php

# Sauvegarde base de données (quotidien à 3h)
0 3 * * * /usr/bin/mysqldump -u votre_utilisateur -pvotre_mot_de_passe votre_nom_base > /home/votre_compte/backups/backup_$(date +\%Y\%m\%d).sql
\`\`\`

## 🚀 Accès à l'application

### Front-office
- **URL** : `https://votre-domaine.com`
- **Inscription** : Créez votre compte utilisateur

### Back-office Admin
- **URL** : `https://votre-domaine.com/admin`
- **Compte par défaut** : 
  - Email : `admin@nouvelacte.fr`
  - Mot de passe : Voir dans la base de données (table `users`)

## 🔍 Dépannage

### Erreur de connexion base de données
1. Vérifiez les paramètres dans `config/database.php`
2. Testez la connexion dans phpMyAdmin
3. Vérifiez que l'utilisateur a les bons privilèges

### Erreur 500
1. Activez le debug : `APP_DEBUG=true` dans `config/database.php`
2. Consultez les logs : `storage/logs/error.log`
3. Vérifiez les permissions des dossiers

### Pages non trouvées
1. Vérifiez que le fichier `.htaccess` est présent
2. Vérifiez que mod_rewrite est activé
3. Contactez votre hébergeur si nécessaire

### Performance lente
1. Activez la compression GZIP dans `.htaccess`
2. Optimisez les images
3. Utilisez un CDN si possible

## 📞 Support

- **Logs d'erreur** : `storage/logs/error.log`
- **Documentation** : Interface admin intégrée
- **Base de données** : Accessible via phpMyAdmin

## 🔒 Sécurité

### Après installation :
1. ✅ Supprimez le dossier `install/`
2. ✅ Changez le mot de passe admin par défaut
3. ✅ Activez SSL/HTTPS
4. ✅ Configurez des sauvegardes régulières
5. ✅ Mettez à jour régulièrement

### Fichiers sensibles protégés :
- ✅ Configuration base de données
- ✅ Logs d'erreur
- ✅ Dossiers système
- ✅ Headers de sécurité configurés
