// JavaScript principal pour l'application Nouvel Acte
// AUCUNE MODIFICATION NÉCESSAIRE POUR CETTE FONCTIONNALITÉ SPÉCIFIQUE

document.addEventListener("DOMContentLoaded", () => {
  // Initialisation
  console.log("Nouvel Acte - Application chargée")

  // Gestion des animations au scroll
  initScrollAnimations()

  // Gestion des formulaires
  initForms()
})

function initScrollAnimations() {
  const observerOptions = {
    threshold: 0.1,
    rootMargin: "0px 0px -50px 0px",
  }

  const observer = new IntersectionObserver((entries) => {
    entries.forEach((entry) => {
      if (entry.isIntersecting) {
        entry.target.style.opacity = "1"
        entry.target.style.transform = "translateY(0)"
      }
    })
  }, observerOptions)

  // Observer les éléments avec animation
  document.querySelectorAll(".card-item, .genre, .featured").forEach((el) => {
    el.style.opacity = "0"
    el.style.transform = "translateY(20px)"
    el.style.transition = "opacity 0.6s ease, transform 0.6s ease"
    observer.observe(el)
  })
}

function initForms() {
  // Validation des formulaires
  const forms = document.querySelectorAll("form")
  forms.forEach((form) => {
    form.addEventListener("submit", function (e) {
      if (!validateForm(this)) {
        e.preventDefault() // Empêche la soumission du formulaire si la validation échoue
      }
    })
  })
}

function validateForm(form) {
  const inputs = form.querySelectorAll("input[required], textarea[required]")
  let isValid = true

  inputs.forEach((input) => {
    // Réinitialiser les erreurs précédentes pour cet input
    clearError(input)
    if (!input.value.trim()) {
      showError(input, "Ce champ est requis.")
      isValid = false
    }
  })

  return isValid
}

function showError(input, message) {
  // S'assurer de ne pas dupliquer les messages d'erreur
  clearError(input)

  const errorDiv = document.createElement("div")
  errorDiv.className = "error-message-js" // Utiliser une classe distincte pour les erreurs JS si nécessaire
  errorDiv.textContent = message
  // Style pour error-message-js (peut être ajouté à style.css si différent de .error-message PHP)
  errorDiv.style.backgroundColor = "#ff4444"
  errorDiv.style.color = "white"
  errorDiv.style.padding = "8px"
  errorDiv.style.fontSize = "12px"
  errorDiv.style.borderRadius = "4px"
  errorDiv.style.marginTop = "4px"
  errorDiv.style.marginBottom = "10px" // Pour espacer avant le prochain champ

  input.parentNode.insertBefore(errorDiv, input.nextSibling) // Insérer après l'input
  input.style.borderColor = "#ff4444" // Optionnel: marquer le champ
}

function clearError(input) {
  let currentElement = input.nextSibling
  // Boucler pour supprimer tous les messages d'erreur JS associés à cet input
  while (currentElement && currentElement.classList && currentElement.classList.contains("error-message-js")) {
    const nextElement = currentElement.nextSibling
    currentElement.remove()
    currentElement = nextElement
  }
  input.style.borderColor = "" // Réinitialiser la bordure
}

// Fonctions utilitaires (non modifiées)
function showNotification(message, type = "info") {
  const notification = document.createElement("div")
  notification.className = `notification notification-${type}` // Assurez-vous que ces classes sont stylées
  notification.textContent = message

  document.body.appendChild(notification)

  // Style pour la notification (peut être dans style.css)
  notification.style.position = "fixed"
  notification.style.top = "20px"
  notification.style.right = "20px"
  notification.style.padding = "15px"
  notification.style.borderRadius = "5px"
  notification.style.color = "white"
  notification.style.zIndex = "1000"
  notification.style.transition = "opacity 0.5s, transform 0.5s"
  notification.style.opacity = "0" // Start hidden for transition
  notification.style.transform = "translateY(-20px)"

  if (type === "success") {
    notification.style.backgroundColor = "#4CAF50"
  } else if (type === "error") {
    notification.style.backgroundColor = "#f44336"
  } else {
    notification.style.backgroundColor = "#2196F3" // Default info
  }

  setTimeout(() => {
    notification.style.opacity = "1"
    notification.style.transform = "translateY(0)"
  }, 100)

  setTimeout(() => {
    notification.style.opacity = "0"
    notification.style.transform = "translateY(-20px)"
    setTimeout(() => notification.remove(), 500) // Attendre la fin de la transition pour supprimer
  }, 3000)
}

function saveToStorage(key, data) {
  try {
    localStorage.setItem(key, JSON.stringify(data))
  } catch (e) {
    console.error("Erreur de sauvegarde:", e)
  }
}

function getFromStorage(key) {
  try {
    const data = localStorage.getItem(key)
    return data ? JSON.parse(data) : null
  } catch (e) {
    console.error("Erreur de lecture:", e)
    return null
  }
}
