-- Structure de la base de données pour le site de réservation de spectacles
-- À exécuter dans phpMyAdmin ou un outil MySQL

CREATE DATABASE IF NOT EXISTS ilanmolia_SAE202 DEFAULT CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE ilanmolia_SAE202;

-- Table des spectacles
DROP TABLE IF EXISTS spectacles;
CREATE TABLE IF NOT EXISTS spectacles (
    id INT AUTO_INCREMENT PRIMARY KEY,
    titre VARCHAR(255) NOT NULL,
    description TEXT,
    date DATE,
    duree INT,
    image VARCHAR(255),
    salle_id INT DEFAULT NULL,
    genre_id INT NOT NULL,
    FOREIGN KEY (salle_id) REFERENCES salles(id) ON DELETE SET NULL,
    FOREIGN KEY (genre_id) REFERENCES genres(id) ON DELETE RESTRICT
);

-- Table des salles
DROP TABLE IF EXISTS salles;
CREATE TABLE IF NOT EXISTS salles (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nom VARCHAR(100) NOT NULL,
    ville VARCHAR(100),
    capacite INT NOT NULL,
    latitude DECIMAL(10,7) DEFAULT NULL,
    longitude DECIMAL(10,7) DEFAULT NULL
);

-- Table des représentations
DROP TABLE IF EXISTS representations;
CREATE TABLE IF NOT EXISTS representations (
    id INT AUTO_INCREMENT PRIMARY KEY,
    spectacle_id INT NOT NULL,
    salle_id INT NOT NULL,
    date DATE NOT NULL,
    heure TIME NOT NULL,
    places_total INT DEFAULT 100,
    places_restantes INT DEFAULT 100,
    FOREIGN KEY (spectacle_id) REFERENCES spectacles(id) ON DELETE CASCADE,
    FOREIGN KEY (salle_id) REFERENCES salles(id) ON DELETE CASCADE
);

-- Table des réservations (liée à une représentation)
DROP TABLE IF EXISTS reservations;
CREATE TABLE IF NOT EXISTS reservations (
    id INT AUTO_INCREMENT PRIMARY KEY,
    representation_id INT NOT NULL,
    nom_client VARCHAR(100),
    email_client VARCHAR(100),
    nb_places INT DEFAULT 1,
    date_reservation DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (representation_id) REFERENCES representations(id) ON DELETE CASCADE
);

-- Table des genres
DROP TABLE IF EXISTS genres;
CREATE TABLE IF NOT EXISTS genres (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nom VARCHAR(100) NOT NULL
);

-- Table des utilisateurs
DROP TABLE IF EXISTS utilisateurs;
CREATE TABLE IF NOT EXISTS utilisateurs (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nom VARCHAR(100) NOT NULL,
    prenom VARCHAR(100) NOT NULL,
    email VARCHAR(150) NOT NULL UNIQUE,
    role ENUM('utilisateur','administrateur') DEFAULT 'utilisateur',
    actif BOOLEAN DEFAULT 1,
    password VARCHAR(255) NOT NULL
);

-- Table des groupes
DROP TABLE IF EXISTS groupes;
CREATE TABLE IF NOT EXISTS groupes (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nom VARCHAR(100) NOT NULL,
    createur_id INT NOT NULL,
    FOREIGN KEY (createur_id) REFERENCES utilisateurs(id) ON DELETE CASCADE
);

-- Table des membres de groupe
DROP TABLE IF EXISTS groupe_membres;
CREATE TABLE IF NOT EXISTS groupe_membres (
    id INT AUTO_INCREMENT PRIMARY KEY,
    groupe_id INT NOT NULL,
    utilisateur_id INT NOT NULL,
    FOREIGN KEY (groupe_id) REFERENCES groupes(id) ON DELETE CASCADE,
    FOREIGN KEY (utilisateur_id) REFERENCES utilisateurs(id) ON DELETE CASCADE
);

-- Table des messages de groupe
DROP TABLE IF EXISTS messages_groupe;
CREATE TABLE IF NOT EXISTS messages_groupe (
    id INT AUTO_INCREMENT PRIMARY KEY,
    groupe_id INT NOT NULL,
    utilisateur_id INT NOT NULL,
    message TEXT NOT NULL,
    date_envoi DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (groupe_id) REFERENCES groupes(id) ON DELETE CASCADE,
    FOREIGN KEY (utilisateur_id) REFERENCES utilisateurs(id) ON DELETE CASCADE
);

-- Table des amis
DROP TABLE IF EXISTS amis;
CREATE TABLE IF NOT EXISTS amis (
    id INT AUTO_INCREMENT PRIMARY KEY,
    utilisateur_id INT NOT NULL,
    ami_id INT NOT NULL,
    statut ENUM('en_attente','accepte','refuse') DEFAULT 'en_attente',
    date_demande DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (utilisateur_id) REFERENCES utilisateurs(id) ON DELETE CASCADE,
    FOREIGN KEY (ami_id) REFERENCES utilisateurs(id) ON DELETE CASCADE,
    UNIQUE KEY unique_ami (utilisateur_id, ami_id)
);

-- Table des favoris (liée à un utilisateur et un spectacle)
DROP TABLE IF EXISTS favoris;
CREATE TABLE IF NOT EXISTS favoris (
    id INT AUTO_INCREMENT PRIMARY KEY,
    utilisateur_id INT NOT NULL,
    spectacle_id INT NOT NULL,
    date_ajout DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (utilisateur_id) REFERENCES utilisateurs(id) ON DELETE CASCADE,
    FOREIGN KEY (spectacle_id) REFERENCES spectacles(id) ON DELETE CASCADE,
    UNIQUE KEY unique_favori (utilisateur_id, spectacle_id)
);

CREATE TABLE IF NOT EXISTS abonnements (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    date_debut DATETIME NOT NULL,
    date_fin DATETIME DEFAULT NULL,
    montant DECIMAL(6,2) NOT NULL,
    FOREIGN KEY (user_id) REFERENCES utilisateurs(id) ON DELETE CASCADE
); 

