<?php
require_once 'db.php';
if (!isset($_SESSION)) session_start();
$user_id = $_SESSION['user_id'] ?? null;

$favoris_amis = [];
if ($user_id) {
    // Récupérer les amis acceptés
    $amis_ids = [];
    $res = $conn->query("SELECT CASE WHEN utilisateur_id = $user_id THEN ami_id ELSE utilisateur_id END as ami_id FROM amis WHERE (utilisateur_id = $user_id OR ami_id = $user_id) AND statut = 'accepte'");
    while ($row = $res->fetch_assoc()) {
        $amis_ids[] = (int)$row['ami_id'];
    }
    if ($amis_ids) {
        $ids_str = implode(',', $amis_ids);
        // Récupérer les favoris de ces amis (on limite à 5 pour la sidebar)
        $sql = "SELECT s.*, u.prenom, u.nom FROM favoris f JOIN spectacles s ON f.spectacle_id = s.id JOIN utilisateurs u ON f.utilisateur_id = u.id WHERE f.utilisateur_id IN ($ids_str) GROUP BY s.id ORDER BY f.date_ajout DESC LIMIT 5";
        $favoris_amis = $conn->query($sql);
    }
}
?>
<div class="profile-box" style="display: flex; flex-direction: row; align-items: center; gap: 1.1rem; text-align: left; background: linear-gradient(135deg, #181818 60%, #232526 100%); border-radius: 1.2em; box-shadow: 0 4px 24px #bb86fc33, 0 1.5px 8px #0008; padding: 1.2em 0 1.3em 1.2em; margin-bottom: 2.7rem; position: relative;">
    <div class="profile-img" style="width: 70px; height: 70px; border-radius: 50%; background: #232323; display: flex; align-items: center; justify-content: center; overflow: hidden; box-shadow: 0 0 0 4px #bb86fc44, 0 2px 12px #0006; margin-bottom: 0; position: relative;">
        <span class="material-icons" style="font-size: 44px; color: #bb86fc; filter: drop-shadow(0 0 8px #bb86fc88);">account_circle</span>
    </div>
    <div class="profile-info" style="display: flex; flex-direction: column; align-items: flex-start; justify-content: center; text-align: left;">
        <div class="profile-name" style="font-weight: 800; font-size: 1.22rem; color: #FFD600; margin-bottom: 0.18em; letter-spacing: 0.5px; text-shadow: 0 2px 8px #0006;">
            <?= htmlspecialchars($_SESSION['prenom'] ?? '') ?>
        </div>
        <div class="profile-username" style="display: inline-block; background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%); color: #fff; font-size: 0.99rem; font-weight: 600; border-radius: 1em; padding: 0.18em 1.1em 0.18em 1.1em; box-shadow: 0 1px 6px #bb86fc33; margin-top: 0.1em; letter-spacing: 0.2px;">
            @du_profil
        </div>
    </div>
</div>

<div style="width:100%;display:flex;flex-direction:column;align-items:center;gap:1.1em;margin-bottom:2.2em;">
    <div class="suggestions-title" style="font-size: 1.13rem; font-weight: 700; color: #fff; text-align: center; width: 100%; letter-spacing: 0.5px; margin-bottom:0;">Mis en favori par tes amis</div>
    <?php if ($favoris_amis && $favoris_amis->num_rows > 0): ?>
        <div class="suggestion-list" style="width: 100%; display: flex; flex-direction: column; gap: 1rem; align-items: center;">
            <?php while ($s = $favoris_amis->fetch_assoc()): ?>
            <div class="suggestion-item" style="display: flex; align-items: center; gap: 0.9rem; background: #181818; border-radius: 1.2rem; padding: 0.7rem 1.2rem; min-width: 220px; max-width: 320px; box-shadow: 0 2px 12px #bb86fc22;">
                <div class="suggestion-img" style="width: 44px; height: 44px; border-radius: 0.8rem; background: #232323; display: flex; align-items: center; justify-content: center; overflow: hidden;">
                    <?php if ($s['image']): ?>
                        <img src="uploads/<?= htmlspecialchars($s['image']) ?>" alt="Affiche" style="width:36px;height:36px;border-radius:50%;object-fit:cover;">
                    <?php else: ?>
                        <span class="material-icons" style="font-size:24px;color:#888;">image</span>
                    <?php endif; ?>
                </div>
                <div class="suggestion-info" style="display: flex; flex-direction: column; align-items: flex-start; text-align: left;">
                    <div class="suggestion-title" style="font-size: 1.05rem; color: #fff; font-weight: 600; line-height: 1.1; margin-bottom: 0.1em;">
                        <?= htmlspecialchars($s['titre']) ?>
                    </div>
                    <div class="suggestion-rating" style="color: #FFD600; font-size: 0.97rem; font-weight: 700;">
                        par <?= htmlspecialchars($s['prenom']) ?>
                    </div>
                </div>
            </div>
            <?php endwhile; ?>
        </div>
    <?php else: ?>
        <div style="display: flex; align-items: center; justify-content: center; gap: 0.7em; background: #232323; color: #bbb; border-radius: 1em; padding: 0.8em 1.2em; font-size: 1.01rem; font-weight: 500; min-width: 220px; max-width: 320px; box-shadow: 0 1px 6px #0002; text-align: center; margin-top: 0.2em;">
            <span class="material-icons" style="font-size: 1.3em; color: #888;">star_border</span>
            Aucun favori d'amis pour le moment.
        </div>
    <?php endif; ?>
    <a href="amis_favoris.php" class="rightbar-btn" style="display:block;text-align:center;background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%); color: #fff; font-weight: 700; border-radius: 1.2rem; padding: 1rem 0; width: 100%; box-shadow: 0 2px 12px #bb86fc22; text-decoration: none;">Voir tout</a>
</div> 