<?php
require_once 'db.php';
// Récupérer toutes les villes distinctes
$villes = $conn->query("SELECT DISTINCT ville FROM salles ORDER BY ville");
$selected_ville = isset($_GET['ville']) ? $conn->real_escape_string($_GET['ville']) : '';
// Ajout d'une réservation
$message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $representation_id = (int)$_POST['representation_id'];
    $nom_client = $conn->real_escape_string($_POST['nom_client']);
    $email_client = $conn->real_escape_string($_POST['email_client']);
    $nb_places = (int)$_POST['nb_places'];
    // Vérifier le nombre de places restantes
    $result = $conn->query("SELECT places_restantes FROM representations WHERE id = $representation_id");
    $row = $result ? $result->fetch_assoc() : null;
    if ($row && $row['places_restantes'] >= $nb_places) {
        $conn->query("INSERT INTO reservations (representation_id, nom_client, email_client, nb_places) VALUES ($representation_id, '$nom_client', '$email_client', $nb_places)");
        $conn->query("UPDATE representations SET places_restantes = places_restantes - $nb_places WHERE id = $representation_id");
        header('Location: reservations.php');
        exit();
    } else {
        $message = "Pas assez de places disponibles pour cette représentation.";
    }
}
// Suppression d'une réservation
if (isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    // Récupérer le nombre de places et l'id de la représentation pour réajouter les places
    $resa = $conn->query("SELECT representation_id, nb_places FROM reservations WHERE id = $id")->fetch_assoc();
    if ($resa) {
        $conn->query("UPDATE representations SET places_restantes = places_restantes + {$resa['nb_places']} WHERE id = {$resa['representation_id']}");
    }
    $conn->query("DELETE FROM reservations WHERE id=$id");
    header('Location: reservations.php');
    exit();
}
// Liste des représentations pour le formulaire, filtrées par ville
if ($selected_ville) {
    $representations = $conn->query("
        SELECT r.id, s.titre AS spectacle, sa.nom AS salle, sa.ville, r.date, r.heure, r.places_restantes
        FROM representations r
        JOIN spectacles s ON r.spectacle_id = s.id
        JOIN salles sa ON r.salle_id = sa.id
        WHERE sa.ville = '$selected_ville'
        ORDER BY r.date DESC, r.heure DESC
    ");
} else {
    $representations = $conn->query("
        SELECT r.id, s.titre AS spectacle, sa.nom AS salle, sa.ville, r.date, r.heure, r.places_restantes
        FROM representations r
        JOIN spectacles s ON r.spectacle_id = s.id
        JOIN salles sa ON r.salle_id = sa.id
        ORDER BY r.date DESC, r.heure DESC
    ");
}
// Liste des réservations (affichage filtré par ville si besoin)
$reservations = $conn->query("
    SELECT res.*, s.titre AS spectacle, sa.nom AS salle, sa.ville, r.date, r.heure
    FROM reservations res
    JOIN representations r ON res.representation_id = r.id
    JOIN spectacles s ON r.spectacle_id = s.id
    JOIN salles sa ON r.salle_id = sa.id
    " . ($selected_ville ? "WHERE sa.ville = '$selected_ville'" : "") . "
    ORDER BY res.date_reservation DESC
");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Réservations</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <aside class="sidebar">
        <h2>Admin Spectacles</h2>
        <nav>
            <ul>
                <li><a href="admin.php">Tableau de bord</a></li>
                <li><a href="spectacles.php">Spectacles</a></li>
                <li><a href="salles.php">Salles</a></li>
                <li><a href="representations.php">Représentations</a></li>
                <li><a href="reservations.php" class="active">Réservations</a></li>
            </ul>
        </nav>
    </aside>
    <main class="main-content">
        <h1>Gestion des Réservations</h1>
        <form method="get" style="margin-bottom:1.5rem;">
            <label for="ville">Filtrer par ville :</label>
            <select name="ville" id="ville" onchange="this.form.submit()">
                <option value="">Toutes les villes</option>
                <?php while ($v = $villes->fetch_assoc()): ?>
                    <option value="<?= htmlspecialchars($v['ville']) ?>" <?= $selected_ville == $v['ville'] ? 'selected' : '' ?>><?= htmlspecialchars($v['ville']) ?></option>
                <?php endwhile; ?>
            </select>
        </form>
        <?php if ($message): ?>
            <div class="alert alert-danger"><?= htmlspecialchars($message) ?></div>
        <?php endif; ?>
        <div class="card">
            <h2>Ajouter une réservation</h2>
            <form method="post">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>Représentation<?= $selected_ville ? ' (ville : ' . htmlspecialchars($selected_ville) . ')' : '' ?></label>
                    <select name="representation_id" required>
                        <option value="">Sélectionnez une représentation</option>
                        <?php while ($r = $representations->fetch_assoc()): ?>
                            <option value="<?= $r['id'] ?>">
                                <?= htmlspecialchars($r['spectacle']) ?> - <?= htmlspecialchars($r['salle']) ?> - <?= htmlspecialchars($r['date']) ?> <?= htmlspecialchars($r['heure']) ?> (<?= $r['places_restantes'] ?> places restantes)
                            </option>
                        <?php endwhile; ?>
                    </select>
                </div>
                <div class="form-group">
                    <label>Nom du client</label>
                    <input type="text" name="nom_client" required>
                </div>
                <div class="form-group">
                    <label>Email du client</label>
                    <input type="email" name="email_client" required>
                </div>
                <div class="form-group">
                    <label>Nombre de places</label>
                    <input type="number" name="nb_places" min="1" value="1" required>
                </div>
                <button type="submit" class="btn btn-primary">Ajouter</button>
            </form>
        </div>
        <div class="card">
            <h2>Liste des réservations<?= $selected_ville ? ' - Ville : ' . htmlspecialchars($selected_ville) : '' ?></h2>
            <table>
                <thead>
                    <tr>
                        <th>Spectacle</th>
                        <th>Salle</th>
                        <th>Ville</th>
                        <th>Date</th>
                        <th>Heure</th>
                        <th>Client</th>
                        <th>Email</th>
                        <th>Places</th>
                        <th>Date réservation</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($res = $reservations->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($res['spectacle']) ?></td>
                        <td><?= htmlspecialchars($res['salle']) ?></td>
                        <td><?= htmlspecialchars($res['ville']) ?></td>
                        <td><?= htmlspecialchars($res['date']) ?></td>
                        <td><?= htmlspecialchars($res['heure']) ?></td>
                        <td><?= htmlspecialchars($res['nom_client']) ?></td>
                        <td><?= htmlspecialchars($res['email_client']) ?></td>
                        <td><?= htmlspecialchars($res['nb_places']) ?></td>
                        <td><?= htmlspecialchars($res['date_reservation']) ?></td>
                        <td>
                            <form method="post" style="display:inline;" onsubmit="return confirm('Supprimer cette réservation ?');">
                                <input type="hidden" name="action" value="delete">
                                <input type="hidden" name="id" value="<?= $res['id'] ?>">
                                <button type="submit" class="btn btn-danger">Supprimer</button>
                            </form>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </main>
</div>
</body>
</html> 