<?php
require_once 'db.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: client_login.php');
    exit();
}
$user_id = (int)$_SESSION['user_id'];
$groupe_id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if ($groupe_id <= 0) {
    header('Location: groupes.php');
    exit();
}
// Vérifier que l'utilisateur est membre du groupe
$stmt = $conn->prepare('SELECT 1 FROM groupe_membres WHERE groupe_id = ? AND utilisateur_id = ?');
$stmt->bind_param('ii', $groupe_id, $user_id);
$stmt->execute();
$stmt->store_result();
if ($stmt->num_rows === 0) {
    header('Location: groupes.php');
    exit();
}
// Récupérer infos groupe
$groupe = $conn->query("SELECT * FROM groupes WHERE id = $groupe_id")->fetch_assoc();
// Suppression du groupe par le créateur
if (isset($_POST['delete_groupe']) && $groupe['createur_id'] == $user_id) {
    $conn->query("DELETE FROM groupes WHERE id = $groupe_id");
    header('Location: groupes.php');
    exit();
}
// Ajouter un ami au groupe
if (isset($_POST['ajouter_ami_id'])) {
    $ami_id = (int)$_POST['ajouter_ami_id'];
    // Vérifier que l'ami est bien dans la liste d'amis
    $verif = $conn->query("SELECT 1 FROM amis WHERE (utilisateur_id = $user_id AND ami_id = $ami_id) OR (utilisateur_id = $ami_id AND ami_id = $user_id)");
    if ($verif && $verif->num_rows > 0) {
        // Vérifier qu'il n'est pas déjà membre
        $verif2 = $conn->query("SELECT 1 FROM groupe_membres WHERE groupe_id = $groupe_id AND utilisateur_id = $ami_id");
        if ($verif2->num_rows == 0) {
            $conn->query("INSERT INTO groupe_membres (groupe_id, utilisateur_id) VALUES ($groupe_id, $ami_id)");
        }
    }
}
// Envoi d'un message
if (isset($_POST['message']) && trim($_POST['message']) !== '') {
    $msg = trim($_POST['message']);
    $stmt = $conn->prepare('INSERT INTO messages_groupe (groupe_id, utilisateur_id, message) VALUES (?, ?, ?)');
    $stmt->bind_param('iis', $groupe_id, $user_id, $msg);
    $stmt->execute();
}
// Récupérer membres du groupe
$membres = $conn->query("SELECT u.id, u.prenom, u.nom FROM utilisateurs u JOIN groupe_membres gm ON u.id = gm.utilisateur_id WHERE gm.groupe_id = $groupe_id ORDER BY u.prenom");
// Récupérer amis non membres
$amis = $conn->query("SELECT u.id, u.prenom, u.nom FROM utilisateurs u WHERE u.id IN (
    SELECT CASE WHEN a.utilisateur_id = $user_id THEN a.ami_id ELSE a.utilisateur_id END
    FROM amis a WHERE (a.utilisateur_id = $user_id OR a.ami_id = $user_id) AND a.statut = 'accepte'
) AND u.id NOT IN (SELECT utilisateur_id FROM groupe_membres WHERE groupe_id = $groupe_id) AND u.id != $user_id");
// Récupérer messages du groupe
$msgs = $conn->query("SELECT m.*, u.prenom, u.nom FROM messages_groupe m JOIN utilisateurs u ON m.utilisateur_id = u.id WHERE m.groupe_id = $groupe_id ORDER BY m.date_envoi ASC");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title><?= htmlspecialchars($groupe['nom']) ?> - Groupe</title>
    
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #121212 0%, #1b1b1b 100%);
            font-family: 'Montserrat', Arial, sans-serif;
            color: #fff;
        }
        .container {
            display: flex;
            min-height: 100vh;
            gap: 2rem;
            padding: 2rem 1rem;
        }
        .sidebar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }
        .sidebar h2 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 1.4rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 2rem;
            color: #fff;
            text-transform: uppercase;
        }
        .sidebar nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .sidebar nav ul li {
            margin-bottom: 1rem;
        }
        .sidebar nav ul li a {
            display: flex;
            align-items: center;
            gap: 0.7rem;
            color: #fff;
            text-decoration: none;
            font-size: 1.08rem;
            font-weight: 600;
            padding: 0.6rem 1.2rem;
            border-radius: 1em;
            background: rgba(255,255,255,0.10);
            border: 1px solid rgba(255,255,255,0.18);
            transition: transform 0.3s, background 0.3s, box-shadow 0.3s, color 0.3s;
        }
        .sidebar nav ul li a.active, .sidebar nav ul li a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
            transition: background 0.45s, color 0.45s, box-shadow 0.45s;
        }
        .main-content {
            flex: 1;
            padding: 2rem 2rem 2rem 2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        .main-content h1 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 2.3rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 1.5rem;
            color: #fff;
            text-shadow: 0 2px 16px #0008;
        }
        .card, .popular-card, .groupe-section, .chat-section {
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            padding: 2rem 2rem 1.5rem 2rem;
            margin-bottom: 2rem;
        }
        .popular-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 2rem;
            justify-content: flex-start;
        }
        .popular-card {
            min-width: 120px;
            max-width: 120px;
            display: flex;
            flex-direction: column;
            align-items: center;
            border: 1px solid rgba(255,255,255,0.18);
            background: rgba(255,255,255,0.13);
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            border-radius: 1.5em;
            padding: 1.2rem 1rem 1.2rem 1rem;
            transition: transform 0.3s, box-shadow 0.3s;
            will-change: transform;
            cursor: pointer;
        }
        .popular-card:hover {
            transform: scale(1.05);
            box-shadow: 0 16px 48px 0 #03dac655;
        }
        .popular-img {
            width: 80px;
            height: 110px;
            background: #bdbdbd;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 0 auto;
            position: relative;
            overflow: hidden;
        }
        .popular-img img, .popular-img span {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 16px;
            display: block;
        }
        .popular-title-card {
            color: #fff;
            font-size: 0.85rem;
            font-weight: bold;
            margin-top: 0.3rem;
            margin-bottom: 0.05rem;
            text-align: center;
            width: 100%;
        }
        .footer-bar {
            width: 100vw;
            background: rgba(18,18,18,0.98);
            color: #fff;
            font-family: 'Montserrat', Arial, sans-serif;
            text-align: center;
            padding: 1.2em 0 1.2em 0;
            font-size: 1.05rem;
            border-top: 1.5px solid #232323;
            box-shadow: 0 -2px 16px #bb86fc22;
            letter-spacing: 0.2px;
            margin-top: 2.5em;
        }
        .footer-bar a {
            color: #bb86fc;
            text-decoration: none;
            font-weight: 700;
            margin: 0 0.7em;
            border-radius: 0.7em;
            padding: 0.2em 0.7em;
            transition: background 0.2s, color 0.2s;
        }
        .footer-bar a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
        }
        .rightbar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }
        @media (max-width: 900px) {
            .container { flex-direction: column; gap: 1rem; }
            .sidebar, .rightbar { width: 100%; min-width: 0; max-width: 100%; }
            .main-content { padding: 1rem; }
        }
        @media (max-width: 600px) {
            .container { flex-direction: column; gap: 0.5rem; padding: 0.5rem; }
            .sidebar, .rightbar, .main-content { padding: 1rem; }
        }
        .rightbar-btn {
            display: inline-block;
            text-align: center;
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            font-weight: 700;
            border-radius: 1.2rem;
            padding: 0.7rem 1.5rem;
            box-shadow: 0 2px 12px #bb86fc22;
            text-decoration: none;
            border: none;
            font-size: 1.08rem;
            transition: background 0.2s, box-shadow 0.2s, color 0.2s, transform 0.2s;
            cursor: pointer;
        }
        .rightbar-btn:hover {
            background: linear-gradient(90deg, #e50914 40%, #bb86fc 100%);
            color: #fff;
            box-shadow: 0 4px 16px #e5091444;
            transform: translateY(-2px);
        }
        .rightbar-btn-block {
            display: block;
            width: 100%;
            margin-top: 1rem;
        }
        .rightbar-btn-inline {
            display: inline-block;
            width: auto;
            margin: 0;
        }
    </style>
</head>
<body>
<div class="container">
    <!-- Sidebar gauche -->
    <aside class="sidebar" data-fade>
        <h2><span class="material-icons" style="color:#bb86fc;margin-right:8px;">theaters</span>NOUVEL ACTE</h2>
        <nav>
            <ul>
                <li><a href="client.php" data-fade><span class="material-icons" style="margin-right:8px;">home</span>Accueil</a></li>
                <li><a href="agenda_culturel.php" data-fade><span class="material-icons" style="margin-right:8px;">event</span>Agenda culturel</a></li>
                <li><a href="favoris.php" data-fade><span class="material-icons" style="margin-right:8px;">star</span>Favoris</a></li>
                <li><a href="mes_reservations.php" data-fade><span class="material-icons" style="margin-right:8px;">confirmation_number</span>Mes réservations</a></li>
                <li><a href="genres_client.php" data-fade><span class="material-icons" style="margin-right:8px;">category</span>Genres</a></li>
                <li><a href="partenaire_client.php" data-fade><span class="material-icons" style="margin-right:8px;">business_center</span>Partenaires</a></li>
                <li style="margin-top:2rem;"><b>Sociale</b></li>
                <li><a href="amis.php" data-fade><span class="material-icons" style="margin-right:8px;">group</span>Amis</a></li>
                <li><a href="groupes.php" data-fade><span class="material-icons" style="margin-right:8px;">groups</span>Groupe</a></li>
                <li style="margin-top:2rem;"><b>Général</b></li>
                <li><a href="abonnement.php" data-fade><span class="material-icons" style="margin-right:8px;">card_membership</span>Abonnement</a></li>
                <li><a href="client_logout.php" data-fade><span class="material-icons" style="margin-right:8px;">logout</span>Se déconnecter</a></li>
                <li><a href="map.php" data-fade><span class="material-icons" style="margin-right:8px;">map</span>Carte des spectacles</a></li>
            </ul>
        </nav>
    </aside>
    <!-- Contenu principal -->
    <main class="main-content">
        <h1><?= htmlspecialchars($groupe['nom']) ?> <span class="material-icons" style="vertical-align:middle;color:#888;">groups</span></h1>
        <div class="card">
            <h2>Membres du groupe</h2>
            <div class="groupe-membres-list">
                <?php while ($m = $membres->fetch_assoc()): ?>
                    <div class="groupe-membre">
                        <?= htmlspecialchars($m['prenom'] . ' ' . $m['nom']) ?>
                        <?php if ($m['id'] == $user_id): ?> <span style="color:#e50914;">(Moi)</span><?php endif; ?>
                    </div>
                <?php endwhile; ?>
            </div>
        </div>
        <div class="card">
            <h2>Ajouter un ami au groupe</h2>
            <div class="groupe-amis-list">
                <?php if ($amis && $amis->num_rows > 0): ?>
                    <?php while ($a = $amis->fetch_assoc()): ?>
                        <form method="post" class="groupe-ami-form">
                            <input type="hidden" name="ajouter_ami_id" value="<?= $a['id'] ?>">
                            <span><?= htmlspecialchars($a['prenom'] . ' ' . $a['nom']) ?></span>
                            <button type="submit" class="rightbar-btn rightbar-btn-inline">Ajouter</button>
                        </form>
                    <?php endwhile; ?>
                <?php else: ?>
                    <span>Aucun ami à ajouter.</span>
                <?php endif; ?>
            </div>
        </div>
        <div class="card chat-section">
            <h2 style="margin-bottom:1rem;">Chat du groupe</h2>
            <div class="chat-box" id="chat-box">
                <?php if ($msgs && $msgs->num_rows > 0): ?>
                    <?php while ($msg = $msgs->fetch_assoc()): ?>
                        <?php
                        $isMe = $msg['utilisateur_id'] == $user_id;
                        $initial = mb_strtoupper(mb_substr($msg['prenom'],0,1,'UTF-8'));
                        ?>
                        <div class="chat-message<?= $isMe ? ' me' : '' ?>">
                            <div class="chat-avatar" title="<?= htmlspecialchars($msg['prenom']) ?>">
                                <?= $initial ?>
                            </div>
                            <div>
                                <div class="chat-bubble">
                                    <?= nl2br(htmlspecialchars($msg['message'])) ?>
                                </div>
                                <div class="chat-meta">
                                    <?= $isMe ? 'Moi' : htmlspecialchars($msg['prenom']) ?> · <?= $msg['date_envoi'] ?>
                                </div>
                            </div>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div style="color:#888;">Aucun message pour l'instant.</div>
                <?php endif; ?>
            </div>
            <form method="post" class="chat-input" autocomplete="off">
                <input type="text" name="message" placeholder="Votre message..." required autocomplete="off">
                <button type="submit" class="rightbar-btn rightbar-btn-inline">Envoyer</button>
            </form>
        </div>
        <?php if ($groupe['createur_id'] == $user_id): ?>
        <div class="card" style="text-align:center;">
            <form method="post" style="margin-top:0;">
                <button type="submit" name="delete_groupe" class="rightbar-btn rightbar-btn-block">Supprimer le groupe</button>
            </form>
        </div>
        <?php endif; ?>
    </main>
    <!-- Sidebar droite -->
    <aside class="rightbar">
        <?php include 'rightbar_favoris_amis.php'; ?>
    </aside>
</div>
<footer class="footer-bar">
    <a href="confidentialite.php">Politiques de confidentialité</a> · <a href="mentions_legales.php">Mentions légales</a>
</footer>
<script>
window.onload = function() {
    var chatBox = document.getElementById('chat-box');
    if (chatBox) chatBox.scrollTop = chatBox.scrollHeight;
}
</script>
</body>
</html> 