<?php
require_once 'db.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: client_login.php');
    exit();
}
// Récupérer tous les genres
$genres = $conn->query("SELECT * FROM genres ORDER BY nom");
// Pour chaque genre, récupérer les spectacles associés
$genres_spectacles = [];
if ($genres) {
    while ($g = $genres->fetch_assoc()) {
        $gid = (int)$g['id'];
        $spectacles = $conn->query("SELECT * FROM spectacles WHERE genre_id = $gid ORDER BY date");
        $genres_spectacles[] = [
            'genre' => $g,
            'spectacles' => $spectacles
        ];
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Genres</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #121212 0%, #1b1b1b 100%);
            font-family: 'Montserrat', Arial, sans-serif;
            color: #fff;
        }
        .container {
            display: flex;
            min-height: 100vh;
            gap: 2rem;
            padding: 2rem 1rem;
        }
        .sidebar, .main-content, .rightbar {
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }
        .sidebar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        .sidebar h2 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 1.4rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 2rem;
            color: #fff;
            text-transform: uppercase;
        }
        .sidebar nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .sidebar nav ul li {
            margin-bottom: 1rem;
        }
        .sidebar nav ul li a {
            display: flex;
            align-items: center;
            gap: 0.7rem;
            color: #fff;
            text-decoration: none;
            font-size: 1.08rem;
            font-weight: 600;
            padding: 0.6rem 1.2rem;
            border-radius: 1em;
            background: rgba(255,255,255,0.10);
            border: 1px solid rgba(255,255,255,0.18);
            transition: transform 0.3s, background 0.3s, box-shadow 0.3s, color 0.3s;
        }
        .sidebar nav ul li a.active, .sidebar nav ul li a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
            transition: background 0.45s, color 0.45s, box-shadow 0.45s;
        }
        .main-content {
            flex: 1;
            padding: 2rem 2rem 2rem 2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        .main-content h1 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 2.3rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 1.5rem;
            color: #fff;
            text-shadow: 0 2px 16px #0008;
        }
        .card {
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            padding: 2rem 2rem 1.5rem 2rem;
            margin-bottom: 2rem;
        }
        .card h2 {
            color: #bb86fc;
            font-size: 1.3rem;
            font-weight: 700;
            margin-bottom: 1.2rem;
        }
        .btn {
            padding: 0.6rem 1.2rem;
            border: none;
            border-radius: 6px;
            cursor: pointer;
            font-weight: 500;
            transition: all 0.3s ease;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
        }
        .btn-primary {
            background-color: #6c5ce7;
            color: white;
        }
        .btn-primary:hover {
            background-color: #5649b8;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .btn-danger {
            background-color: #e50914;
            color: white;
        }
        .btn-danger:hover {
            background-color: #b0060f;
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.1);
        }
        .popular-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 2rem;
            justify-content: flex-start;
        }
        .popular-card {
            min-width: 120px;
            max-width: 120px;
            display: flex;
            flex-direction: column;
            align-items: center;
            border: 1px solid rgba(255,255,255,0.18);
            background: rgba(255,255,255,0.13);
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            border-radius: 1.5em;
            padding: 1.2rem 1rem 1.2rem 1rem;
            transition: transform 0.3s, box-shadow 0.3s;
            will-change: transform;
            cursor: pointer;
        }
        .popular-card:hover {
            transform: scale(1.05);
            box-shadow: 0 16px 48px 0 #03dac655;
        }
        .popular-img {
            width: 80px;
            height: 110px;
            background: #bdbdbd;
            border-radius: 16px;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 0 auto;
            position: relative;
            overflow: hidden;
        }
        .popular-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 16px;
            display: block;
        }
        .popular-title-card {
            color: #fff;
            font-size: 0.85rem;
            font-weight: bold;
            margin-top: 0.3rem;
            margin-bottom: 0.05rem;
            text-align: center;
            width: 100%;
        }
        .footer-bar {
            width: 100vw;
            background: rgba(18,18,18,0.98);
            color: #fff;
            font-family: 'Montserrat', Arial, sans-serif;
            text-align: center;
            padding: 1.2em 0 1.2em 0;
            font-size: 1.05rem;
            border-top: 1.5px solid #232323;
            box-shadow: 0 -2px 16px #bb86fc22;
            letter-spacing: 0.2px;
            margin-top: 2.5em;
        }
        .footer-bar a {
            color: #bb86fc;
            text-decoration: none;
            font-weight: 700;
            margin: 0 0.7em;
            border-radius: 0.7em;
            padding: 0.2em 0.7em;
            transition: background 0.2s, color 0.2s;
        }
        .footer-bar a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
        }
        .rightbar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        .profile-box {
            display: flex;
            flex-direction: row;
            align-items: center;
            gap: 1.1rem;
            text-align: left;
            background: linear-gradient(135deg, #181818 60%, #232526 100%);
            border-radius: 1.2em;
            box-shadow: 0 4px 24px #bb86fc33, 0 1.5px 8px #0008;
            padding: 1.2em 0 1.3em 1.2em;
            margin-bottom: 2.7rem;
            position: relative;
        }
        .profile-img {
            width: 70px;
            height: 70px;
            border-radius: 50%;
            background: #232323;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
            box-shadow: 0 0 0 4px #bb86fc44, 0 2px 12px #0006;
            margin-bottom: 0;
            position: relative;
        }
        .profile-name {
            font-weight: 800;
            font-size: 1.22rem;
            color: #FFD600;
            margin-bottom: 0.18em;
            letter-spacing: 0.5px;
            text-shadow: 0 2px 8px #0006;
        }
        .profile-username {
            display: inline-block;
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            font-size: 0.99rem;
            font-weight: 600;
            border-radius: 1em;
            padding: 0.18em 1.1em 0.18em 1.1em;
            box-shadow: 0 1px 6px #bb86fc33;
            margin-top: 0.1em;
            letter-spacing: 0.2px;
        }
        .suggestions-title {
            font-size: 1.13rem;
            font-weight: 700;
            color: #fff;
            text-align: center;
            width: 100%;
            letter-spacing: 0.5px;
            margin-bottom:0;
        }
        .suggestion-list {
            width: 100%;
            display: flex;
            flex-direction: column;
            gap: 1rem;
            align-items: center;
        }
        .suggestion-item {
            display: flex;
            align-items: center;
            gap: 0.9rem;
            background: #181818;
            border-radius: 1.2rem;
            padding: 0.7rem 1.2rem;
            min-width: 220px;
            max-width: 320px;
            box-shadow: 0 2px 12px #bb86fc22;
        }
        .suggestion-img {
            width: 44px;
            height: 44px;
            border-radius: 0.8rem;
            background: #232323;
            display: flex;
            align-items: center;
            justify-content: center;
            overflow: hidden;
        }
        .suggestion-title {
            font-size: 1.05rem;
            color: #fff;
            font-weight: 600;
            line-height: 1.1;
            margin-bottom: 0.1em;
        }
        .suggestion-rating {
            color: #FFD600;
            font-size: 0.97rem;
            font-weight: 700;
        }
        .rightbar-btn {
            display: block;
            text-align: center;
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            font-weight: 700;
            border-radius: 1.2rem;
            padding: 1rem 0;
            width: 100%;
            box-shadow: 0 2px 12px #bb86fc22;
            text-decoration: none;
        }
        @media (max-width: 900px) {
            .container { flex-direction: column; gap: 1rem; }
            .sidebar, .rightbar { width: 100%; min-width: 0; max-width: 100%; }
            .main-content { padding: 1rem; }
        }
        @media (max-width: 600px) {
            .container { flex-direction: column; gap: 0.5rem; padding: 0.5rem; }
            .sidebar, .rightbar, .main-content { padding: 1rem; }
        }
        .genre-title {
            margin-bottom: 1.1em;
        }
    </style>
</head>
<body>
<div class="container">
    <!-- Sidebar gauche -->
    <aside class="sidebar">
        <h2><span class="material-icons" style="color:#bb86fc;margin-right:8px;">theaters</span>NOUVEL ACTE</h2>
        <nav>
            <ul>
                <li><a href="client.php"><span class="material-icons" style="margin-right:8px;">home</span>Accueil</a></li>
                <li><a href="agenda_culturel.php"><span class="material-icons" style="margin-right:8px;">event</span>Agenda culturel</a></li>
                <li><a href="favoris.php"><span class="material-icons" style="margin-right:8px;">star</span>Favoris</a></li>
                <li><a href="mes_reservations.php"><span class="material-icons" style="margin-right:8px;">confirmation_number</span>Mes réservations</a></li>
                <li><a href="genres_client.php" class="active"><span class="material-icons" style="margin-right:8px;">category</span>Genres</a></li>
                <li><a href="partenaire_client.php"><span class="material-icons" style="margin-right:8px;">business_center</span>Partenaires</a></li>
                <li style="margin-top:2rem;"><b>Sociale</b></li>
                <li><a href="amis.php"><span class="material-icons" style="margin-right:8px;">group</span>Amis</a></li>
                <li><a href="groupes.php"><span class="material-icons" style="margin-right:8px;">groups</span>Groupe</a></li>
                <li style="margin-top:2rem;"><b>Général</b></li>
                <li><a href="abonnement.php"><span class="material-icons" style="margin-right:8px;">card_membership</span>Abonnement</a></li>
                <li><a href="client_logout.php"><span class="material-icons" style="margin-right:8px;">logout</span>Se déconnecter</a></li>
                <li><a href="map.php"><span class="material-icons" style="margin-right:8px;">map</span>Carte des spectacles</a></li>
            </ul>
        </nav>
    </aside>
    <!-- Contenu principal -->
    <main class="main-content">
        <h1>Genres</h1>
        <?php foreach ($genres_spectacles as $gs): ?>
            <?php if (strtolower($gs['genre']['nom']) === 'evènements') continue; ?>
            <div class="genre-section">
                <div class="genre-title" id="genre-<?= $gs['genre']['id'] ?>"><?= htmlspecialchars($gs['genre']['nom']) ?></div>
                <div class="popular-grid">
                <?php if ($gs['spectacles'] && $gs['spectacles']->num_rows > 0): ?>
                    <?php while ($s = $gs['spectacles']->fetch_assoc()): ?>
                        <div class="popular-card" onclick="window.location.href='spectacle.php?id=<?= $s['id'] ?>'">
                            <div class="popular-img">
                                <?php if ($s['image']): ?>
                                    <img src="uploads/<?= htmlspecialchars($s['image']) ?>" alt="Affiche">
                                <?php else: ?>
                                    <span class="material-icons" style="font-size:40px;color:#888;">image</span>
                                <?php endif; ?>
                            </div>
                            <div class="popular-title-card"><?= htmlspecialchars($s['titre']) ?></div>
                        </div>
                    <?php endwhile; ?>
                <?php else: ?>
                    <div style="color:#888;">Aucun spectacle pour ce genre.</div>
                <?php endif; ?>
                </div>
            </div>
        <?php endforeach; ?>
    </main>
    <!-- Sidebar droite -->
    <aside class="rightbar">
        <?php include 'rightbar_favoris_amis.php'; ?>
    </aside>
</div>
<footer class="footer-bar">
    <a href="confidentialite.php">Politiques de confidentialité</a> · <a href="mentions_legales.php">Mentions légales</a>
</footer>
</body>
</html> 