<?php
require_once 'db.php';
// Ajout d'un genre
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'add') {
    $nom = $conn->real_escape_string($_POST['nom']);
    $conn->query("INSERT INTO genres (nom) VALUES ('$nom')");
    header('Location: genres.php');
    exit();
}
// Modification d'un genre
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'edit' && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $nom = $conn->real_escape_string($_POST['nom']);
    $conn->query("UPDATE genres SET nom = '$nom' WHERE id = $id");
    header('Location: genres.php');
    exit();
}
// Suppression d'un genre
if (isset($_POST['action']) && $_POST['action'] === 'delete' && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $conn->query("DELETE FROM genres WHERE id=$id");
    header('Location: genres.php');
    exit();
}
// Liste des genres
$genres = $conn->query("SELECT * FROM genres ORDER BY nom");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Genres</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <?php include 'admin_sidebar.php'; ?>
    <main class="main-content">
        <h1>Gestion des Genres</h1>
        <div class="card">
            <h2>Ajouter un genre</h2>
            <form method="post">
                <input type="hidden" name="action" value="add">
                <div class="form-group">
                    <label>Nom du genre</label>
                    <input type="text" name="nom" required>
                </div>
                <button type="submit" class="btn btn-primary">Ajouter</button>
            </form>
        </div>
        <div class="card">
            <h2>Liste des genres</h2>
            <table>
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($g = $genres->fetch_assoc()): ?>
                    <?php if (strtolower($g['nom']) === 'evènements') continue; ?>
                    <tr>
                        <form method="post" style="display:inline;">
                            <td>
                                <input type="text" name="nom" value="<?= htmlspecialchars($g['nom']) ?>" required style="width: 90%;">
                                <input type="hidden" name="id" value="<?= $g['id'] ?>">
                            </td>
                            <td>
                                <button type="submit" name="action" value="edit" class="btn btn-primary">Modifier</button>
                                <button type="submit" name="action" value="delete" class="btn btn-danger" onclick="return confirm('Supprimer ce genre ?');">Supprimer</button>
                            </td>
                        </form>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
    </main>
</div>
</body>
</html> 