<?php
require_once 'db.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: landing.php');
    exit();
}
// Récupérer les genres
$genres = $conn->query("SELECT * FROM genres ORDER BY nom");
// Trouver l'ID du genre 'Evènements'
$evts_genre_id = null;
$res = $conn->query("SELECT id FROM genres WHERE LOWER(nom) = 'evènements' LIMIT 1");
if ($res && $row = $res->fetch_assoc()) {
    $evts_genre_id = (int)$row['id'];
}
// Récupérer les spectacles (exemple : les 6 plus populaires), en excluant 'Evènements'
if ($evts_genre_id) {
    $spectacles = $conn->query("SELECT * FROM spectacles WHERE genre_id != $evts_genre_id ORDER BY id DESC LIMIT 6");
} else {
    $spectacles = $conn->query("SELECT * FROM spectacles ORDER BY id DESC LIMIT 6");
}
// Récupérer les suggestions d'amis (exemple)
$amis = $conn->query("SELECT u.id, u.prenom, u.nom FROM utilisateurs u JOIN amis a ON a.ami_id = u.id WHERE a.utilisateur_id = {$_SESSION['user_id']} AND a.statut = 'accepte' LIMIT 4");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Espace Client</title>
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #121212 0%, #1b1b1b 100%);
            font-family: 'Montserrat', Arial, sans-serif;
            color: #fff;
        }
        .container {
            display: flex;
            min-height: 100vh;
            gap: 2rem;
            padding: 2rem 1rem;
        }
        .sidebar, .rightbar, .main-content, .popular-card, .search-bar, .genres-bar, .profile-box, .suggestion-list, .agenda-card {
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }
        .sidebar, .rightbar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        .sidebar h2 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 1.4rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 2rem;
            color: #fff;
            text-transform: uppercase;
        }
        .sidebar nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .sidebar nav ul li {
            margin-bottom: 1rem;
        }
        .sidebar nav ul li a {
            display: flex;
            align-items: center;
            gap: 0.7rem;
            color: #fff;
            text-decoration: none;
            font-size: 1.08rem;
            font-weight: 600;
            padding: 0.6rem 1.2rem;
            border-radius: 1em;
            background: rgba(255,255,255,0.10);
            border: 1px solid rgba(255,255,255,0.18);
            transition: transform 0.3s, background 0.3s, box-shadow 0.3s, color 0.3s;
        }
        .sidebar nav ul li a.active, .sidebar nav ul li a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
            transition: background 0.45s, color 0.45s, box-shadow 0.45s;
        }
        .main-content {
            flex: 1;
            padding: 2rem 2rem 2rem 2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        .main-content h1 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 2.3rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 1.5rem;
            color: #fff;
            text-shadow: 0 2px 16px #0008;
        }
        .search-bar {
            display: flex;
            align-items: center;
            gap: 1rem;
            padding: 0.7rem 1.5rem;
            margin-bottom: 1.5rem;
            border-radius: 2em;
            border: 1px solid rgba(255,255,255,0.18);
            background: rgba(255,255,255,0.10);
            box-shadow: 0 2px 12px #0002;
            transition: box-shadow 0.3s;
        }
        .search-bar input[type="text"] {
            background: transparent;
            border: none;
            color: #fff;
            font-size: 1.1rem;
            flex: 1;
            outline: none;
            padding: 0.5rem 0.5rem;
        }
        .search-bar .material-icons {
            color: #bb86fc;
            font-size: 1.3rem;
        }
        .genres-bar {
            display: flex;
            gap: 1rem;
            margin-bottom: 1.5rem;
            padding: 0.7rem 1rem;
            border-radius: 1em;
            overflow-x: auto;
        }
        .genre-item {
            background: rgba(255,255,255,0.13);
            color: #fff;
            font-weight: 600;
            font-size: 1.08rem;
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1em;
            padding: 0.5rem 1.2rem;
            margin-right: 0.5rem;
            cursor: pointer;
            transition: background 0.3s, color 0.3s, transform 0.3s;
        }
        .genre-item:hover, .genre-item:focus {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            transform: scale(1.05);
            box-shadow: 0 1px 4px #bb86fc33;
            transition: background 0.45s, color 0.45s, box-shadow 0.45s, transform 0.3s;
        }
        .popular-section {
            margin-top: 1.5rem;
        }
        .popular-title {
            font-size: 1.3rem;
            font-weight: 700;
            color: #bb86fc;
            margin-bottom: 1.2rem;
            letter-spacing: 1px;
        }
        .popular-grid {
            display: flex;
            flex-wrap: wrap;
            gap: 2rem;
            justify-content: flex-start;
        }
        .popular-card {
            min-width: 120px;
            max-width: 120px;
            display: flex;
            flex-direction: column;
            align-items: center;
            border: 1px solid rgba(255,255,255,0.18);
            background: rgba(255,255,255,0.13);
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            border-radius: 1.5em;
            padding: 1.2rem 1rem 1.2rem 1rem;
            transition: transform 0.3s, box-shadow 0.3s;
            will-change: transform;
        }
        .popular-card:hover {
            transform: scale(1.05);
            box-shadow: 0 16px 48px 0 #03dac655;
        }
        .popular-img {
            width: 100px;
            height: 140px;
            background: rgba(255,255,255,0.10);
            border-radius: 1em;
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 auto 0 auto;
            position: relative;
            overflow: hidden;
            transition: box-shadow 0.3s;
        }
        .popular-img img {
            width: 100%;
            height: 100%;
            object-fit: cover;
            border-radius: 1em;
            filter: brightness(1.15) contrast(1.15);
            transition: filter 0.3s, transform 0.3s;
        }
        .popular-img img:hover {
            filter: brightness(1.25) contrast(1.25);
            transform: scale(1.08) translateY(-4px);
        }
        .popular-title-card {
            color: #fff;
            font-size: 1rem;
            font-weight: bold;
            margin-top: 0.4rem;
            margin-bottom: 0.1rem;
            text-align: center;
            width: 100%;
        }
        .popular-rating {
            color: #03dac6;
            font-size: 1rem;
            font-weight: bold;
            display: flex;
            align-items: center;
            gap: 0.3em;
            justify-content: center;
            width: 100%;
            margin-top: 0.1rem;
        }
        .popular-rating .material-icons,
        .popular-rating .star {
            color: #bb86fc;
            font-size: 1.1em;
            margin-right: 0.2em;
            vertical-align: middle;
            font-weight: bold;
        }
        .popular-rating span {
            color: #03dac6;
            font-weight: bold;
        }
        .rightbar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        @media (max-width: 900px) {
            .container { flex-direction: column; gap: 1rem; }
            .sidebar, .rightbar { width: 100%; min-width: 0; max-width: 100%; }
            .main-content { padding: 1rem; }
        }
        @media (max-width: 600px) {
            .container { flex-direction: column; gap: 0.5rem; padding: 0.5rem; }
            .sidebar, .rightbar, .main-content { padding: 1rem; }
        }
        /* Footer */
        .footer-bar {
            width: 100vw;
            background: rgba(18,18,18,0.98);
            color: #fff;
            font-family: 'Montserrat', Arial, sans-serif;
            text-align: center;
            padding: 1.2em 0 1.2em 0;
            font-size: 1.05rem;
            border-top: 1.5px solid #232323;
            box-shadow: 0 -2px 16px #bb86fc22;
            letter-spacing: 0.2px;
            margin-top: 2.5em;
        }
        .footer-bar a {
            color: #bb86fc;
            text-decoration: none;
            font-weight: 700;
            margin: 0 0.7em;
            border-radius: 0.7em;
            padding: 0.2em 0.7em;
            transition: background 0.2s, color 0.2s;
        }
        .footer-bar a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
        }
        @media (max-width: 800px) {
            .footer-bar {
                font-size: 0.97rem;
                padding: 0.8em 0;
            }
        }
    </style>
</head>
<body>
<canvas id="curtain-bg"></canvas>
<div class="container">
    <!-- Sidebar gauche -->
    <aside class="sidebar" data-fade>
        <h2><span class="material-icons" style="color:#bb86fc;margin-right:8px;">theaters</span>NOUVEL ACTE</h2>
        <nav>
            <ul>
                <li><a href="client.php" class="active" data-fade><span class="material-icons" style="margin-right:8px;">home</span>Accueil</a></li>
                <li><a href="agenda_culturel.php" data-fade><span class="material-icons" style="margin-right:8px;">event</span>Agenda culturel</a></li>
                <li><a href="favoris.php" data-fade><span class="material-icons" style="margin-right:8px;">star</span>Favoris</a></li>
                <li><a href="mes_reservations.php" data-fade><span class="material-icons" style="margin-right:8px;">confirmation_number</span>Mes réservations</a></li>
                <li><a href="genres_client.php" data-fade><span class="material-icons" style="margin-right:8px;">category</span>Genres</a></li>
                <li><a href="partenaire_client.php" data-fade><span class="material-icons" style="margin-right:8px;">business_center</span>Partenaires</a></li>
                <li style="margin-top:2rem;"><b>Sociale</b></li>
                <li><a href="amis.php" data-fade><span class="material-icons" style="margin-right:8px;">group</span>Amis</a></li>
                <li><a href="groupes.php" data-fade><span class="material-icons" style="margin-right:8px;">groups</span>Groupe</a></li>
                <li style="margin-top:2rem;"><b>Général</b></li>
                <li><a href="abonnement.php" data-fade><span class="material-icons" style="margin-right:8px;">card_membership</span>Abonnement</a></li>
                <li><a href="client_logout.php" data-fade><span class="material-icons" style="margin-right:8px;">logout</span>Se déconnecter</a></li>
                <li><a href="map.php" data-fade><span class="material-icons" style="margin-right:8px;">map</span>Carte des spectacles</a></li>
            </ul>
        </nav>
    </aside>
    <!-- Contenu principal -->
    <main class="main-content" data-fade>
        <h1 data-fade>Bienvenue !</h1>
        <!-- Barre de recherche -->
        <form class="search-bar" method="get" action="resultats_recherche.php" data-fade>
            <span class="material-icons search-icon">search</span>
            <input type="text" name="q" placeholder="Rechercher">
            <span class="material-icons filter-icon">tune</span>
            <span class="material-icons notif-icon">notifications</span>
        </form>
        <!-- Genres -->
        <div class="genres-bar" data-fade>
            <?php while ($g = $genres->fetch_assoc()): ?>
                <?php if (strtolower($g['nom']) === 'evènements'): ?>
                    <button class="genre-item" onclick="window.location.href='agenda_culturel.php'">
                        <?= htmlspecialchars($g['nom']) ?>
                    </button>
                <?php else: ?>
                    <button class="genre-item" onclick="window.location.href='genres_client.php'">
                        <?= htmlspecialchars($g['nom']) ?>
                    </button>
                <?php endif; ?>
            <?php endwhile; ?>
        </div>
        <!-- Section populaire -->
        <div class="popular-section" data-fade>
            <div class="popular-title">Spectacle Populaire <a href="tous_spectacles.php" style="float:right;color:#fff;font-size:0.95rem;">Voir plus</a></div>
            <div class="popular-grid">
                <?php while ($s = $spectacles->fetch_assoc()): ?>
                <div class="popular-card" data-fade onclick="window.location.href='spectacle.php?id=<?= $s['id'] ?>'">
                    <div class="popular-img">
                        <?php if ($s['image']): ?>
                            <img src="uploads/<?= htmlspecialchars($s['image']) ?>" alt="Affiche">
                        <?php else: ?>
                            <span class="material-icons" style="font-size:40px;color:#888;">image</span>
                        <?php endif; ?>
                    </div>
                    <div class="popular-title-card"><?= htmlspecialchars($s['titre']) ?></div>
                    <div class="popular-rating" style="max-width:100%;display:flex;align-items:center;justify-content:center;flex-wrap:wrap;word-break:keep-all;">
                        <?php
                        $avis_data = $conn->query("SELECT AVG(note) as avg_note, COUNT(*) as nb FROM avis WHERE id_spectacle = " . (int)$s['id'])->fetch_assoc();
                        $moyenne = $avis_data && $avis_data['avg_note'] ? round($avis_data['avg_note'], 1) : 0;
                        $nb_avis = $avis_data ? (int)$avis_data['nb'] : 0;
                        for ($i = 1; $i <= 5; $i++) {
                            $color = $i <= round($moyenne) ? '#FFD600' : '#888';
                            echo '<span class="material-icons star" style="color:' . $color . ';font-size:0.92em;line-height:1;">star</span>';
                        }
                        echo '<span style="font-size:0.89em;font-weight:bold;color:#03dac6;margin-left:0.12em;">' . $moyenne . '</span>';
                        echo '<span style="font-size:0.85em;color:#bdbdbd;margin-left:0.10em;">(' . $nb_avis . ')</span>';
                        ?>
                    </div>
                </div>
                <?php endwhile; ?>
            </div>
        </div>
    </main>
    <!-- Sidebar droite -->
    <aside class="rightbar" data-fade>
        <?php include 'rightbar_favoris_amis.php'; ?>
    </aside>
</div>
<footer class="footer-bar">
    <a href="confidentialite.php">Politiques de confidentialité</a> · <a href="mentions_legales.php">Mentions légales</a>
</footer>
<script>
// Fade-up apparition via Intersection Observer
const fadeEls = document.querySelectorAll('[data-fade]');
const fadeObs = new IntersectionObserver((entries, obs) => {
  entries.forEach(entry => {
    if (entry.isIntersecting) {
      entry.target.style.opacity = 1;
      entry.target.style.transform = 'translateY(0)';
      obs.unobserve(entry.target);
    }
  });
}, { threshold: 0.1 });
fadeEls.forEach(el => {
  el.style.opacity = 0;
  el.style.transform = 'translateY(40px)';
  el.style.transition = 'opacity 0.7s cubic-bezier(.4,2,.3,1), transform 0.7s cubic-bezier(.4,2,.3,1)';
  fadeObs.observe(el);
});
// Tilt 3D sur cartes
function handleTilt(e) {
  const card = e.currentTarget;
  const rect = card.getBoundingClientRect();
  const x = e.clientX - rect.left;
  const y = e.clientY - rect.top;
  const cx = rect.width/2, cy = rect.height/2;
  const dx = (x-cx)/cx, dy = (y-cy)/cy;
  card.style.transform = `perspective(1000px) rotateX(${-dy*8}deg) rotateY(${dx*8}deg) scale(1.05)`;
}
function resetTilt(e) {
  e.currentTarget.style.transform = '';
}
document.querySelectorAll('.popular-card').forEach(card => {
  card.addEventListener('mousemove', handleTilt);
  card.addEventListener('mouseleave', resetTilt);
});
// Rideaux rouges animés (fond)
const curtain = document.getElementById('curtain-bg');
if (curtain) {
  let w = window.innerWidth, h = window.innerHeight;
  curtain.width = w; curtain.height = h;
  curtain.style.position = 'fixed';
  curtain.style.top = 0;
  curtain.style.left = 0;
  curtain.style.width = '100vw';
  curtain.style.height = '100vh';
  curtain.style.zIndex = 0;
  curtain.style.pointerEvents = 'none';
  const ctx = curtain.getContext('2d');
  function drawCurtain() {
    ctx.clearRect(0,0,w,h);
    // Gauche
    ctx.save();
    ctx.beginPath();
    ctx.moveTo(0,0);
    for(let y=0;y<=h;y+=4){
      let x = 0 + 60*Math.sin(y/110+Date.now()/1800) + 24*Math.sin(y/40+Date.now()/900);
      ctx.lineTo(x,y);
    }
    ctx.lineTo(0,h); ctx.closePath();
    let gradL = ctx.createLinearGradient(0,0,180,0);
    gradL.addColorStop(0,'#a80000');
    gradL.addColorStop(0.5,'#d32f2f');
    gradL.addColorStop(1,'#ff5252');
    ctx.fillStyle = gradL;
    ctx.globalAlpha = 0.92;
    ctx.shadowColor = '#b71c1c';
    ctx.shadowBlur = 32;
    ctx.fill();
    ctx.globalAlpha = 1;
    ctx.restore();
    // Droite
    ctx.save();
    ctx.beginPath();
    ctx.moveTo(w,0);
    for(let y=0;y<=h;y+=4){
      let x = w - 60*Math.sin(y/110+Date.now()/1700+1.2) - 24*Math.sin(y/40+Date.now()/1000+1.5);
      ctx.lineTo(x,y);
    }
    ctx.lineTo(w,h); ctx.closePath();
    let gradR = ctx.createLinearGradient(w-180,0,w,0);
    gradR.addColorStop(0,'#ff5252');
    gradR.addColorStop(0.5,'#d32f2f');
    gradR.addColorStop(1,'#a80000');
    ctx.fillStyle = gradR;
    ctx.globalAlpha = 0.92;
    ctx.shadowColor = '#b71c1c';
    ctx.shadowBlur = 32;
    ctx.fill();
    ctx.globalAlpha = 1;
    ctx.restore();
    // Ombre centrale
    ctx.save();
    let gradC = ctx.createLinearGradient(w/2-60,0,w/2+60,0);
    gradC.addColorStop(0,'rgba(0,0,0,0)');
    gradC.addColorStop(0.5,'rgba(0,0,0,0.18)');
    gradC.addColorStop(1,'rgba(0,0,0,0)');
    ctx.fillStyle = gradC;
    ctx.fillRect(w/2-60,0,120,h);
    ctx.restore();
  }
  function animate() {
    drawCurtain();
    requestAnimationFrame(animate);
  }
  animate();
  window.addEventListener('resize',()=>{
    w = window.innerWidth; h = window.innerHeight;
    curtain.width = w; curtain.height = h;
  });
}
</script>
</body>
</html>