<?php
require_once 'db.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: client_login.php');
    exit();
}
$user_id = (int)$_SESSION['user_id'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : 0;
if (!$id) { header('Location: client.php'); exit(); }
$spectacle = $conn->query("SELECT * FROM spectacles WHERE id = $id")->fetch_assoc();
if (!$spectacle) { header('Location: client.php'); exit(); }
// --- Gestion des avis ---
$avis_message = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['ajouter_avis'])) {
    $titre_avis = trim($_POST['titre_avis'] ?? '');
    $note_avis = (int)($_POST['note_avis'] ?? 0);
    $commentaire_avis = trim($_POST['commentaire_avis'] ?? '');
    if ($note_avis < 1 || $note_avis > 5) $note_avis = 1;
    if (mb_strlen($titre_avis) < 2 || mb_strlen($titre_avis) > 100) {
        $avis_message = "Le titre doit faire entre 2 et 100 caractères.";
    } elseif (mb_strlen($commentaire_avis) < 2 || mb_strlen($commentaire_avis) > 300) {
        $avis_message = "Le commentaire doit faire entre 2 et 300 caractères.";
    } else {
        $existe = $conn->query("SELECT id FROM avis WHERE id_spectacle=$id AND id_utilisateur=$user_id")->fetch_assoc();
        if ($existe) {
            $avis_message = "Vous avez déjà posté un avis pour ce spectacle.";
        } else {
            $titre_avis = htmlspecialchars($titre_avis);
            $commentaire_avis = htmlspecialchars($commentaire_avis);
            $conn->query("INSERT INTO avis (id_spectacle, id_utilisateur, note, titre, commentaire) VALUES ($id, $user_id, $note_avis, '$titre_avis', '$commentaire_avis')");
            header("Location: avis_spectacle.php?id=$id");
            exit();
        }
    }
}
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['signaler_avis_id'])) {
    $avis_id = (int)$_POST['signaler_avis_id'];
    $conn->query("UPDATE avis SET signale=1 WHERE id=$avis_id");
    $admin_mail = 'admin@tonsite.fr';
    $avis_info = $conn->query("SELECT a.*, u.email FROM avis a JOIN utilisateurs u ON a.id_utilisateur = u.id WHERE a.id=$avis_id")->fetch_assoc();
    if ($avis_info) {
        $sujet = "[Signalement] Avis à modérer sur un spectacle";
        $message = "Un avis a été signalé :\n\n" .
            "Spectacle ID: $id\n" .
            "Utilisateur: " . $avis_info['email'] . "\n" .
            "Note: " . $avis_info['note'] . "\n" .
            "Titre: " . $avis_info['titre'] . "\n" .
            "Commentaire: " . $avis_info['commentaire'] . "\n" .
            "Date: " . $avis_info['date'] . "\n";
        @mail($admin_mail, $sujet, $message);
    }
    $avis_message = "Merci, l'avis a été signalé.";
}
$avis = $conn->query("SELECT a.*, u.prenom, u.nom FROM avis a JOIN utilisateurs u ON a.id_utilisateur = u.id WHERE a.id_spectacle = $id ORDER BY a.date DESC");
$nb_avis = $avis->num_rows;
$moyenne = $conn->query("SELECT AVG(note) as avg_note FROM avis WHERE id_spectacle = $id")->fetch_assoc();
$moyenne_note = $moyenne && $moyenne['avg_note'] ? round($moyenne['avg_note'], 2) : 0;
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Avis sur <?= htmlspecialchars($spectacle['titre']) ?></title>
    <link rel="stylesheet" href="client_pages.css">
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <style>
        body { background: linear-gradient(120deg, #181818 0%, #232526 100%); color: #f5f5f5; }
        .avis-main { max-width: 700px; margin: 3.5rem auto 2.5rem auto; background: #181818; border-radius: 2.2em; box-shadow: 0 4px 32px #000a; padding: 2.5em 2.2em; }
        .avis-header { display: flex; align-items: center; gap: 1.5em; margin-bottom: 2em; }
        .avis-img { width: 90px; height: 120px; border-radius: 1.2em; background: #232526; overflow: hidden; box-shadow: 0 2px 12px #0004; }
        .avis-img img { width: 100%; height: 100%; object-fit: cover; border-radius: 1.2em; }
        .avis-title { font-size: 2rem; font-weight: 900; color: #FFD600; margin-bottom: 0.2em; }
        .avis-rating { display: flex; align-items: center; gap: 0.5em; font-size: 1.3em; margin-bottom: 0.2em; }
        .avis-rating .material-icons { font-size: 1.5em; }
        .avis-count { color: #fff; font-size: 1.1em; margin-left: 1.2em; }
        .avis-form { background: #232526; border-radius: 1.2em; padding: 1.5em 1.5em 1.2em 1.5em; margin-bottom: 2em; }
        .avis-form h3 { color: #FFD600; margin-bottom: 0.7em; }
        .avis-form label { color: #fff; font-weight: 600; margin-bottom: 0.3em; display: block; }
        .avis-form input, .avis-form select, .avis-form textarea { width: 100%; padding: 0.6em; border-radius: 0.7em; border: 1px solid #444; margin-bottom: 0.7em; background: #181818; color: #fff; font-size: 1em; }
        .avis-form button { background: #e50914; color: #fff; border: none; border-radius: 1.2rem; padding: 0.7rem 1.5rem; font-size: 1.05rem; font-weight: 700; cursor: pointer; margin-top: 0.3rem; transition: background 0.2s; box-shadow: 0 2px 8px #0006; }
        .avis-form button:hover { background: #b0060f; }
        .avis-list { margin-top: 2.2em; }
        .avis-item { background: #232526; border-radius: 1em; padding: 1em 1.2em; margin-bottom: 1.2em; position: relative; }
        .avis-item .avis-meta { display: flex; align-items: center; gap: 1em; margin-bottom: 0.5em; }
        .avis-item .avis-note { font-weight: bold; color: #FFD600; }
        .avis-item .avis-titre { color: #fff; font-weight: 600; }
        .avis-item .avis-user { color: #bdbdbd; font-size: 0.98em; }
        .avis-item .avis-comment { margin: 0.7em 0 0.5em 0; color: #e0e0e0; }
        .avis-item form { position: absolute; top: 1em; right: 1.2em; }
        .avis-item button { background: #FFD600; color: #222; padding: 0.3em 1em; font-size: 0.95em; border-radius: 0.7em; border: none; cursor: pointer; }
        .avis-item button:hover { background: #e50914; color: #fff; }
        @media (max-width: 800px) { .avis-main { padding: 1.2em 0.3em; } .avis-header { flex-direction: column; align-items: flex-start; } }
    </style>
</head>
<body>
    <div class="avis-main">
        <div class="avis-header">
            <div class="avis-img">
                <?php if ($spectacle['image']): ?>
                    <img src="uploads/<?= htmlspecialchars($spectacle['image']) ?>" alt="Affiche">
                <?php else: ?>
                    <span class="material-icons" style="font-size:60px;color:#888;">image</span>
                <?php endif; ?>
            </div>
            <div>
                <div class="avis-title">Avis sur "<?= htmlspecialchars($spectacle['titre']) ?>"</div>
                <div class="avis-rating">
                    <?php for ($i = 1; $i <= 5; $i++): ?>
                        <span class="material-icons" style="color:<?= $i <= round($moyenne_note) ? '#FFD600' : '#888' ?>;">star</span>
                    <?php endfor; ?>
                    <span style="color:#FFD600;font-weight:bold;">(<?= $moyenne_note ?>/5)</span>
                    <span class="avis-count">• <?= $nb_avis ?> avis</span>
                </div>
            </div>
        </div>
        <div class="avis-form">
            <h3>Laisser un avis</h3>
            <?php if ($avis_message): ?><div style="color:#e50914;font-weight:bold;"> <?= htmlspecialchars($avis_message) ?> </div><?php endif; ?>
            <form method="post">
                <input type="hidden" name="ajouter_avis" value="1">
                <label>Titre de l'avis <input type="text" name="titre_avis" maxlength="100" required></label>
                <label>Note
                    <select name="note_avis" required>
                        <option value="">Choisir</option>
                        <?php for ($i=1;$i<=5;$i++): ?><option value="<?= $i ?>"><?= $i ?> ★</option><?php endfor; ?>
                    </select>
                </label>
                <label>Commentaire (max 300 caractères)
                    <textarea name="commentaire_avis" maxlength="300" required></textarea>
                </label>
                <button type="submit">Envoyer l'avis</button>
            </form>
        </div>
        <div class="avis-list">
            <h3 style="color:#FFD600;margin-bottom:0.7em;">Critiques et avis</h3>
            <?php if ($nb_avis > 0): ?>
                <?php foreach ($avis as $a): ?>
                    <div class="avis-item">
                        <div class="avis-meta">
                            <span class="avis-note">★ <?= (int)$a['note'] ?>/5</span>
                            <span class="avis-titre">"<?= htmlspecialchars($a['titre']) ?>"</span>
                            <span class="avis-user">par <?= htmlspecialchars($a['prenom']) ?> <?= htmlspecialchars($a['nom']) ?>, le <?= date('d/m/Y H:i', strtotime($a['date'])) ?></span>
                        </div>
                        <div class="avis-comment"> <?= nl2br(htmlspecialchars($a['commentaire'])) ?> </div>
                        <form method="post">
                            <input type="hidden" name="signaler_avis_id" value="<?= $a['id'] ?>">
                            <button type="submit">Signaler</button>
                        </form>
                    </div>
                <?php endforeach; ?>
            <?php else: ?>
                <div style="color:#888;">Aucun avis pour ce spectacle.</div>
            <?php endif; ?>
        </div>
        <a href="spectacle.php?id=<?= $spectacle['id'] ?>" style="display:inline-block;margin-top:2.2em;color:#e50914;font-weight:bold;text-decoration:none;font-size:1.1em;">← Retour à la fiche spectacle</a>
    </div>
</body>
</html> 