<?php
require_once 'db.php';
// Accepter/refuser une demande d'ami
if (isset($_POST['action']) && in_array($_POST['action'], ['accepter','refuser']) && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $statut = $_POST['action'] === 'accepter' ? 'accepte' : 'refuse';
    $conn->query("UPDATE amis SET statut = '$statut' WHERE id = $id");
    header('Location: admin_amis.php');
    exit();
}
// Supprimer une amitié
if (isset($_POST['action']) && $_POST['action'] === 'supprimer' && isset($_POST['id'])) {
    $id = (int)$_POST['id'];
    $conn->query("DELETE FROM amis WHERE id = $id");
    header('Location: admin_amis.php');
    exit();
}
// Voir les amis d'un utilisateur
$amis_utilisateur = null;
$utilisateur_nom = '';
if (isset($_GET['user'])) {
    $uid = (int)$_GET['user'];
    $user = $conn->query("SELECT nom, prenom FROM utilisateurs WHERE id = $uid")->fetch_assoc();
    $utilisateur_nom = $user ? $user['prenom'] . ' ' . $user['nom'] : '';
    $amis_utilisateur = $conn->query("
        SELECT u.id, u.nom, u.prenom, u.email
        FROM utilisateurs u
        JOIN amis a ON (
            (a.utilisateur_id = $uid AND a.ami_id = u.id)
            OR (a.ami_id = $uid AND a.utilisateur_id = u.id)
        )
        WHERE a.statut = 'accepte' AND u.id != $uid
        ORDER BY u.nom, u.prenom
    ");
}
// Voir les amis en commun entre deux utilisateurs
$amis_communs = null;
if (isset($_GET['user1']) && isset($_GET['user2'])) {
    $u1 = (int)$_GET['user1'];
    $u2 = (int)$_GET['user2'];
    $amis_communs = $conn->query("
        SELECT u.id, u.nom, u.prenom, u.email
        FROM utilisateurs u
        WHERE u.id != $u1 AND u.id != $u2
        AND u.id IN (
            SELECT CASE WHEN a.utilisateur_id = $u1 THEN a.ami_id ELSE a.utilisateur_id END
            FROM amis a
            WHERE (a.utilisateur_id = $u1 OR a.ami_id = $u1) AND a.statut = 'accepte'
        )
        AND u.id IN (
            SELECT CASE WHEN a.utilisateur_id = $u2 THEN a.ami_id ELSE a.utilisateur_id END
            FROM amis a
            WHERE (a.utilisateur_id = $u2 OR a.ami_id = $u2) AND a.statut = 'accepte'
        )
        ORDER BY u.nom, u.prenom
    ");
}
// Liste de toutes les demandes d'amis
$demandes = $conn->query("
    SELECT a.*, u1.nom AS nom1, u1.prenom AS prenom1, u2.nom AS nom2, u2.prenom AS prenom2
    FROM amis a
    JOIN utilisateurs u1 ON a.utilisateur_id = u1.id
    JOIN utilisateurs u2 ON a.ami_id = u2.id
    ORDER BY a.date_demande DESC
");
// Liste de tous les utilisateurs pour sélection
$all_users = $conn->query("SELECT id, nom, prenom FROM utilisateurs ORDER BY nom, prenom");
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Gestion des Amis</title>
    <link rel="stylesheet" href="style.css">
</head>
<body>
<div class="container">
    <?php include 'admin_sidebar.php'; ?>
    <main class="main-content">
        <h1>Gestion des Amis</h1>
        <div class="card">
            <h2>Demandes d'amis et amitiés</h2>
            <table>
                <thead>
                    <tr>
                        <th>Demandeur</th>
                        <th>Destinataire</th>
                        <th>Statut</th>
                        <th>Date</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($a = $demandes->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($a['prenom1'] . ' ' . $a['nom1']) ?></td>
                        <td><?= htmlspecialchars($a['prenom2'] . ' ' . $a['nom2']) ?></td>
                        <td><?= htmlspecialchars(ucfirst($a['statut'])) ?></td>
                        <td><?= htmlspecialchars($a['date_demande']) ?></td>
                        <td>
                            <?php if ($a['statut'] === 'en_attente'): ?>
                                <form method="post" style="display:inline;">
                                    <input type="hidden" name="id" value="<?= $a['id'] ?>">
                                    <button type="submit" name="action" value="accepter" class="btn btn-success">Accepter</button>
                                    <button type="submit" name="action" value="refuser" class="btn btn-danger">Refuser</button>
                                </form>
                            <?php endif; ?>
                            <form method="post" style="display:inline;" onsubmit="return confirm('Supprimer cette amitié ?');">
                                <input type="hidden" name="id" value="<?= $a['id'] ?>">
                                <button type="submit" name="action" value="supprimer" class="btn btn-danger">Supprimer</button>
                            </form>
                            <a href="admin_amis.php?user=<?= $a['utilisateur_id'] ?>">Voir amis</a>
                            <a href="admin_amis.php?user=<?= $a['ami_id'] ?>">Voir amis</a>
                        </td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
        </div>
        <div class="card">
            <h2>Voir les amis d'un utilisateur</h2>
            <form method="get" style="margin-bottom:1rem;">
                <select name="user">
                    <option value="">Sélectionnez un utilisateur</option>
                    <?php while ($u = $all_users->fetch_assoc()): ?>
                        <option value="<?= $u['id'] ?>" <?= isset($_GET['user']) && $_GET['user'] == $u['id'] ? 'selected' : '' ?>><?= htmlspecialchars($u['prenom'] . ' ' . $u['nom']) ?></option>
                    <?php endwhile; ?>
                </select>
                <button type="submit" class="btn btn-primary">Voir amis</button>
            </form>
            <?php if ($amis_utilisateur): ?>
            <table>
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>Prénom</th>
                        <th>Email</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($am = $amis_utilisateur->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($am['nom']) ?></td>
                        <td><?= htmlspecialchars($am['prenom']) ?></td>
                        <td><?= htmlspecialchars($am['email']) ?></td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
        <div class="card">
            <h2>Voir les amis en commun entre deux utilisateurs</h2>
            <form method="get" style="margin-bottom:1rem; display:flex; gap:1rem;">
                <select name="user1">
                    <option value="">Utilisateur 1</option>
                    <?php
                    $all_users->data_seek(0);
                    while ($u = $all_users->fetch_assoc()): ?>
                        <option value="<?= $u['id'] ?>" <?= isset($_GET['user1']) && $_GET['user1'] == $u['id'] ? 'selected' : '' ?>><?= htmlspecialchars($u['prenom'] . ' ' . $u['nom']) ?></option>
                    <?php endwhile; ?>
                </select>
                <select name="user2">
                    <option value="">Utilisateur 2</option>
                    <?php
                    $all_users->data_seek(0);
                    while ($u = $all_users->fetch_assoc()): ?>
                        <option value="<?= $u['id'] ?>" <?= isset($_GET['user2']) && $_GET['user2'] == $u['id'] ? 'selected' : '' ?>><?= htmlspecialchars($u['prenom'] . ' ' . $u['nom']) ?></option>
                    <?php endwhile; ?>
                </select>
                <button type="submit" class="btn btn-primary">Voir amis en commun</button>
            </form>
            <?php if ($amis_communs): ?>
            <table>
                <thead>
                    <tr>
                        <th>Nom</th>
                        <th>Prénom</th>
                        <th>Email</th>
                    </tr>
                </thead>
                <tbody>
                <?php while ($amc = $amis_communs->fetch_assoc()): ?>
                    <tr>
                        <td><?= htmlspecialchars($amc['nom']) ?></td>
                        <td><?= htmlspecialchars($amc['prenom']) ?></td>
                        <td><?= htmlspecialchars($amc['email']) ?></td>
                    </tr>
                <?php endwhile; ?>
                </tbody>
            </table>
            <?php endif; ?>
        </div>
    </main>
</div>
</body>
</html> 