<?php
require_once 'db.php';
session_start();
if (!isset($_SESSION['user_id'])) {
    header('Location: client_login.php');
    exit();
}
$user_id = (int)$_SESSION['user_id'];
// Vérifier l'abonnement
$abo = $conn->query("SELECT * FROM abonnements WHERE user_id = $user_id AND (date_fin IS NULL OR date_fin > NOW())")->fetch_assoc();
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['abonner'])) {
    // Paiement fictif, activer l'abonnement pour 1 mois
    $conn->query("INSERT INTO abonnements (user_id, date_debut, date_fin, montant) VALUES ($user_id, NOW(), DATE_ADD(NOW(), INTERVAL 1 MONTH), 10)");
    header('Location: abonnement.php');
    exit();
}
// Annulation d'abonnement
$annul_msg = '';
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['annuler_abo'])) {
    $conn->query("UPDATE abonnements SET date_fin = NOW() WHERE user_id = $user_id AND (date_fin IS NULL OR date_fin > NOW())");
    $annul_msg = "Votre abonnement a été annulé. Il reste actif jusqu'à la date de fin.";
    // Rafraîchir l'objet $abo
    $abo = $conn->query("SELECT * FROM abonnements WHERE user_id = $user_id AND (date_fin IS NULL OR date_fin > NOW())")->fetch_assoc();
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <title>Abonnement</title>
    <link rel="stylesheet" href="https://fonts.googleapis.com/icon?family=Material+Icons">
    <link href="https://fonts.googleapis.com/css2?family=Montserrat:wght@400;700&display=swap" rel="stylesheet">
    <style>
        body {
            min-height: 100vh;
            margin: 0;
            background: linear-gradient(135deg, #121212 0%, #1b1b1b 100%);
            font-family: 'Montserrat', Arial, sans-serif;
            color: #fff;
        }
        .container {
            display: flex;
            min-height: 100vh;
            gap: 2rem;
            padding: 2rem 1rem;
        }
        .sidebar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            backdrop-filter: blur(20px);
            -webkit-backdrop-filter: blur(20px);
        }
        .sidebar h2 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 1.4rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 2rem;
            color: #fff;
            text-transform: uppercase;
        }
        .sidebar nav ul {
            list-style: none;
            padding: 0;
            margin: 0;
        }
        .sidebar nav ul li {
            margin-bottom: 1rem;
        }
        .sidebar nav ul li a {
            display: flex;
            align-items: center;
            gap: 0.7rem;
            color: #fff;
            text-decoration: none;
            font-size: 1.08rem;
            font-weight: 600;
            padding: 0.6rem 1.2rem;
            border-radius: 1em;
            background: rgba(255,255,255,0.10);
            border: 1px solid rgba(255,255,255,0.18);
            transition: transform 0.3s, background 0.3s, box-shadow 0.3s, color 0.3s;
        }
        .sidebar nav ul li a.active, .sidebar nav ul li a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
            transition: background 0.45s, color 0.45s, box-shadow 0.45s;
        }
        .main-content {
            flex: 1;
            padding: 2rem 2rem 2rem 2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        .main-content h1 {
            font-family: 'Montserrat', Arial, sans-serif;
            font-size: 2.3rem;
            font-weight: 700;
            letter-spacing: 2px;
            margin-bottom: 1.5rem;
            color: #fff;
            text-shadow: 0 2px 16px #0008;
        }
        .card {
            background: rgba(255,255,255,0.13);
            border: 1px solid rgba(255,255,255,0.18);
            border-radius: 1.5em;
            box-shadow: 0 8px 32px 0 rgba(31,38,135,0.18);
            padding: 2rem 2rem 1.5rem 2rem;
            margin-bottom: 2rem;
            max-width: 480px;
        }
        .abo-title {
            font-size: 2.1rem;
            font-weight: bold;
            margin-bottom: 1.2rem;
            color: #e50914;
        }
        .abo-desc {
            font-size: 1.1rem;
            margin-bottom: 2rem;
        }
        .abo-btn {
            background: #e50914;
            color: #fff;
            border: none;
            border-radius: 1.2rem;
            padding: 1rem 2.2rem;
            font-size: 1.2rem;
            font-weight: 700;
            cursor: pointer;
            transition: background 0.2s;
            box-shadow: 0 2px 8px #0006;
        }
        .abo-btn:hover {
            background: #b0060f;
        }
        .abo-status {
            font-size: 1.1rem;
            margin-bottom: 1.5rem;
            color: #FFD600;
        }
        .abo-advantages {
            background: rgba(255,255,255,0.07);
            border-radius: 1rem;
            padding: 1.2rem;
            margin-bottom: 2rem;
        }
        .abo-advantages ul {
            margin: 0;
            padding-left: 1.2em;
        }
        .footer-bar {
            width: 100vw;
            background: rgba(18,18,18,0.98);
            color: #fff;
            font-family: 'Montserrat', Arial, sans-serif;
            text-align: center;
            padding: 1.2em 0 1.2em 0;
            font-size: 1.05rem;
            border-top: 1.5px solid #232323;
            box-shadow: 0 -2px 16px #bb86fc22;
            letter-spacing: 0.2px;
            margin-top: 2.5em;
        }
        .footer-bar a {
            color: #bb86fc;
            text-decoration: none;
            font-weight: 700;
            margin: 0 0.7em;
            border-radius: 0.7em;
            padding: 0.2em 0.7em;
            transition: background 0.2s, color 0.2s;
        }
        .footer-bar a:hover {
            background: linear-gradient(90deg, #bb86fc 40%, #e50914 100%);
            color: #fff;
            box-shadow: 0 1px 4px #bb86fc33;
        }
        .rightbar {
            min-width: 220px;
            max-width: 270px;
            padding: 2rem 1.2rem;
            display: flex;
            flex-direction: column;
            gap: 2rem;
        }
        @media (max-width: 900px) {
            .container { flex-direction: column; gap: 1rem; }
            .sidebar, .rightbar { width: 100%; min-width: 0; max-width: 100%; }
            .main-content { padding: 1rem; }
        }
        @media (max-width: 600px) {
            .container { flex-direction: column; gap: 0.5rem; padding: 0.5rem; }
            .sidebar, .rightbar, .main-content { padding: 1rem; }
        }
    </style>
</head>
<body>
<div class="container">
    <!-- Sidebar gauche -->
    <aside class="sidebar">
        <h2><span class="material-icons" style="color:#bb86fc;margin-right:8px;">theaters</span>NOUVEL ACTE</h2>
        <nav>
            <ul>
                <li><a href="client.php"><span class="material-icons" style="margin-right:8px;">home</span>Accueil</a></li>
                <li><a href="agenda_culturel.php"><span class="material-icons" style="margin-right:8px;">event</span>Agenda culturel</a></li>
                <li><a href="favoris.php"><span class="material-icons" style="margin-right:8px;">star</span>Favoris</a></li>
                <li><a href="mes_reservations.php"><span class="material-icons" style="margin-right:8px;">confirmation_number</span>Mes réservations</a></li>
                <li><a href="genres_client.php"><span class="material-icons" style="margin-right:8px;">category</span>Genres</a></li>
                <li><a href="partenaire_client.php"><span class="material-icons" style="margin-right:8px;">business_center</span>Partenaires</a></li>
                <li style="margin-top:2rem;"><b>Sociale</b></li>
                <li><a href="amis.php"><span class="material-icons" style="margin-right:8px;">group</span>Amis</a></li>
                <li><a href="groupes.php"><span class="material-icons" style="margin-right:8px;">groups</span>Groupe</a></li>
                <li style="margin-top:2rem;"><b>Général</b></li>
                <li><a href="abonnement.php" class="active"><span class="material-icons" style="margin-right:8px;">card_membership</span>Abonnement</a></li>
                <li><a href="client_logout.php"><span class="material-icons" style="margin-right:8px;">logout</span>Se déconnecter</a></li>
                <li><a href="map.php"><span class="material-icons" style="margin-right:8px;">map</span>Carte des spectacles</a></li>
            </ul>
        </nav>
    </aside>
    <!-- Contenu principal -->
    <main class="main-content">
        <h1>Abonnement Culture+</h1>
        <!-- Section abonnement -->
        <div class="abo-title">Abonnement Culture+ <span style="font-size:1.1rem;color:#FFD600;">10€ / mois</span></div>
        <div class="abo-advantages">
            <strong style="display:block;margin-bottom:0.7em;">Avantages de l'abonnement :</strong>
            <ul>
                <li>Accès <b>illimité</b> à une place par jour pour n'importe quel spectacle</li>
                <li>Réservation prioritaire</li>
                <li>Offres exclusives abonnés</li>
            </ul>
            <div style="margin-top:1.2em;color:#bdbdbd;font-size:0.98em;">Sans abonnement : 1 réservation par mois maximum.</div>
        </div>
        <?php if (!empty($annul_msg)): ?>
            <div class="abo-status" style="color:#FFD600;"> <?= htmlspecialchars($annul_msg) ?> </div>
        <?php endif; ?>
        <?php if ($abo): ?>
            <div class="abo-status">Vous êtes abonné jusqu'au <?= date('d/m/Y', strtotime($abo['date_fin'])) ?>.</div>
            <div style="display:flex; gap:1em; align-items:center;">
                <button class="abo-btn" disabled>Déjà abonné</button>
                <form method="post" style="display:inline; margin:0;">
                    <button type="submit" name="annuler_abo" class="abo-btn" style="background:#444;color:#FFD600;">Annuler mon abonnement</button>
                </form>
            </div>
        <?php else: ?>
            <form method="post">
                <button type="submit" name="abonner" class="abo-btn">S'abonner pour 10€ / mois</button>
            </form>
        <?php endif; ?>
    </main>
    <!-- Sidebar droite -->
    <aside class="rightbar">
        <?php include 'rightbar_favoris_amis.php'; ?>
    </aside>
</div>
<footer class="footer-bar">
    <a href="confidentialite.php">Politiques de confidentialité</a> · <a href="mentions_legales.php">Mentions légales</a>
</footer>
</body>
</html> 