<?php
session_start();
require_once '../config/database.php';

if (isset($_SESSION['user_id'])) {
    $database = new Database();
    $db = $database->getConnection();
    
    // Log de déconnexion
    $log_query = "INSERT INTO logs (user_id, action, ip_address) VALUES (:user_id, 'logout', :ip)";
    $log_stmt = $db->prepare($log_query);
    $log_stmt->bindParam(':user_id', $_SESSION['user_id']);
    $log_stmt->bindParam(':ip', $_SERVER['REMOTE_ADDR']);
    $log_stmt->execute();
}

// Détruire la session
session_destroy();

// Rediriger vers la page d'accueil
header('Location: ../index.html');
exit();
?>
