<?php
session_start();
require_once 'config/database.php';

$error = '';
$success = '';

if ($_POST) {
    $email = trim($_POST['email']);
    $password = $_POST['password'];
    $confirm_password = $_POST['confirm_password'];
    $display_name = trim($_POST['display_name']);
    
    // Validation
    if (empty($email) || empty($password) || empty($display_name)) {
        $error = 'Tous les champs sont requis';
    } elseif (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        $error = 'Email invalide';
    } elseif (strlen($password) < 6) {
        $error = 'Le mot de passe doit contenir au moins 6 caractères';
    } elseif ($password !== $confirm_password) {
        $error = 'Les mots de passe ne correspondent pas';
    } else {
        $database = new Database();
        $db = $database->getConnection();
        
        // Vérifier si l'email existe déjà
        $check_query = "SELECT id FROM users WHERE email = :email";
        $check_stmt = $db->prepare($check_query);
        $check_stmt->bindParam(':email', $email);
        $check_stmt->execute();
        
        if ($check_stmt->rowCount() > 0) {
            $error = 'Cet email est déjà utilisé';
        } else {
            // Créer l'utilisateur
            $password_hash = password_hash($password, PASSWORD_DEFAULT);
            $role_id = 2; // Client par défaut
            
            $insert_query = "INSERT INTO users (email, password_hash, display_name, role_id) 
                            VALUES (:email, :password_hash, :display_name, :role_id)";
            $insert_stmt = $db->prepare($insert_query);
            $insert_stmt->bindParam(':email', $email);
            $insert_stmt->bindParam(':password_hash', $password_hash);
            $insert_stmt->bindParam(':display_name', $display_name);
            $insert_stmt->bindParam(':role_id', $role_id);
            
            if ($insert_stmt->execute()) {
                $success = 'Compte créé avec succès ! Vous pouvez maintenant vous connecter.';
            } else {
                $error = 'Erreur lors de la création du compte';
            }
        }
    }
}
?>

<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Nouvel Acte - Inscription</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body class="auth-page">
    <div class="auth-background">
        <!-- Logo -->
        <div class="logo">
            <a href="index.html">
                <div class="logo-icon"></div>
                <div class="logo-text">Nouvel Acte</div>
            </a>
        </div>

        <!-- Formulaire d'inscription -->
        <div class="auth-card">
            <h1>Créer un compte</h1>
            
            <?php if ($error): ?>
                <div class="error-message"><?php echo htmlspecialchars($error); ?></div>
            <?php endif; ?>
            
            <?php if ($success): ?>
                <div class="success-message"><?php echo htmlspecialchars($success); ?></div>
            <?php endif; ?>
            
            <form method="POST" action="">
                <input type="text" name="display_name" placeholder="Nom complet" value="<?php echo htmlspecialchars($_POST['display_name'] ?? ''); ?>" required>
                <input type="email" name="email" placeholder="E-mail" value="<?php echo htmlspecialchars($_POST['email'] ?? ''); ?>" required>
                <input type="password" name="password" placeholder="Mot de passe" required>
                <input type="password" name="confirm_password" placeholder="Confirmer le mot de passe" required>
                <button type="submit">S'inscrire</button>
            </form>
            
            <div class="auth-links">
                <a href="identification.php">Déjà un compte ? Se connecter</a>
            </div>
        </div>
    </div>
</body>
</html>
