// JavaScript pour la page des amis

document.addEventListener("DOMContentLoaded", () => {
  initFriends()
  initSearch()
  initNotifications()
})

function initFriends() {
  console.log("Page amis initialisée")

  // Animer les cartes
  animateFriendCards()

  // Initialiser les interactions
  initFriendInteractions()
}

function animateFriendCards() {
  const cards = document.querySelectorAll(".friend-card, .suggestion-card, .request-card")

  cards.forEach((card, index) => {
    card.style.opacity = "0"
    card.style.transform = "translateY(20px)"

    setTimeout(() => {
      card.style.transition = "all 0.6s ease"
      card.style.opacity = "1"
      card.style.transform = "translateY(0)"
    }, index * 100)
  })
}

function initFriendInteractions() {
  const friendCards = document.querySelectorAll(".friend-card, .suggestion-card")

  friendCards.forEach((card) => {
    card.addEventListener("mouseenter", function () {
      this.style.transform = "translateY(-5px) scale(1.02)"
      this.style.boxShadow = "0 8px 20px rgba(0,0,0,0.12)"
    })

    card.addEventListener("mouseleave", function () {
      this.style.transform = "translateY(0) scale(1)"
      this.style.boxShadow = ""
    })
  })

  // Animation pour les demandes d'amitié
  const requestCards = document.querySelectorAll(".request-card")
  requestCards.forEach((card) => {
    card.style.borderLeft = "4px solid #e30b17"
    card.style.background = "linear-gradient(90deg, rgba(227, 11, 23, 0.05) 0%, transparent 100%)"
  })
}

function initSearch() {
  const searchInput = document.getElementById("searchInput")

  if (searchInput) {
    searchInput.addEventListener("input", function () {
      const query = this.value.toLowerCase()
      searchFriends(query)
    })
  }
}

function searchFriends(query) {
  const cards = document.querySelectorAll(".friend-card, .suggestion-card")

  cards.forEach((card) => {
    const name = card.querySelector("h4").textContent.toLowerCase()

    if (name.includes(query)) {
      card.style.display = "block"
    } else {
      card.style.display = "none"
    }
  })
}

function initNotifications() {
  // Mettre à jour le badge de notifications
  updateNotificationBadge()

  // Animer les nouvelles demandes
  const pendingRequests = document.querySelectorAll(".request-card")
  pendingRequests.forEach((request, index) => {
    setTimeout(() => {
      request.style.animation = "slideInRight 0.5s ease"
    }, index * 200)
  })
}

function updateNotificationBadge() {
  const badge = document.querySelector(".notification-badge")
  const pendingCount = document.querySelectorAll(".request-card").length

  if (badge && pendingCount > 0) {
    badge.textContent = pendingCount
    badge.style.animation = "pulse 2s infinite"
  }
}

function viewFriendProfile(friendId) {
  // Ouvrir le profil de l'ami dans une modal
  showFriendProfileModal(friendId)
}

function showFriendProfileModal(friendId) {
  // Créer une modal pour afficher le profil
  const modal = document.createElement("div")
  modal.className = "modal friend-profile-modal"
  modal.innerHTML = `
    <div class="modal-content">
      <div class="modal-header">
        <h3>Profil de l'ami</h3>
        <button class="modal-close" onclick="closeFriendProfileModal()">&times;</button>
      </div>
      <div class="modal-body">
        <div class="loading">Chargement du profil...</div>
      </div>
    </div>
  `

  document.body.appendChild(modal)
  modal.style.display = "flex"

  // Charger les données du profil
  loadFriendProfile(friendId, modal)
}

function loadFriendProfile(friendId, modal) {
  // Simuler le chargement des données
  setTimeout(() => {
    const modalBody = modal.querySelector(".modal-body")
    modalBody.innerHTML = `
      <div class="friend-profile">
        <div class="profile-avatar">
          <img src="assets/images/avatar-placeholder.jpg" alt="Avatar">
        </div>
        <div class="profile-info">
          <h4>Nom de l'ami</h4>
          <p>@username</p>
          <div class="profile-stats">
            <div class="stat">
              <span class="number">12</span>
              <span class="label">Spectacles vus</span>
            </div>
            <div class="stat">
              <span class="number">8</span>
              <span class="label">Avis donnés</span>
            </div>
          </div>
        </div>
      </div>
      <div class="common-interests">
        <h5>Goûts en commun</h5>
        <div class="interests-list">
          <span class="interest-tag">Comédie</span>
          <span class="interest-tag">Musical</span>
        </div>
      </div>
    `
  }, 1000)
}

function closeFriendProfileModal() {
  const modal = document.querySelector(".friend-profile-modal")
  if (modal) {
    modal.style.opacity = "0"
    setTimeout(() => modal.remove(), 300)
  }
}

function inviteToShow(friendId) {
  // Ouvrir la modal d'invitation
  showInviteModal(friendId)
}

function showInviteModal(friendId) {
  const modal = document.createElement("div")
  modal.className = "modal invite-modal"
  modal.innerHTML = `
    <div class="modal-content">
      <div class="modal-header">
        <h3>Inviter un ami</h3>
        <button class="modal-close" onclick="closeInviteModal()">&times;</button>
      </div>
      <div class="modal-body">
        <p>Choisissez un spectacle pour inviter votre ami :</p>
        <div class="shows-list">
          <div class="show-option">
            <img src="assets/images/placeholder.jpg" alt="Spectacle">
            <div class="show-info">
              <h5>Le Malade Imaginaire</h5>
              <p>15/03/2024 à 20h00</p>
            </div>
            <button class="btn btn-primary" onclick="sendInvite(${friendId}, 1)">
              Inviter
            </button>
          </div>
        </div>
      </div>
    </div>
  `

  document.body.appendChild(modal)
  modal.style.display = "flex"
}

function closeInviteModal() {
  const modal = document.querySelector(".invite-modal")
  if (modal) {
    modal.style.opacity = "0"
    setTimeout(() => modal.remove(), 300)
  }
}

function sendInvite(friendId, showId) {
  // Simuler l'envoi d'invitation
  showNotification("Invitation envoyée !", "success")
  closeInviteModal()
}

function openInviteModal() {
  showInviteModal(null)
}

function showNotification(message, type) {
  const notification = document.createElement("div")
  notification.className = `notification ${type}`
  notification.textContent = message

  document.body.appendChild(notification)

  setTimeout(() => {
    notification.classList.add("show")
  }, 100)

  setTimeout(() => {
    notification.classList.remove("show")
    setTimeout(() => notification.remove(), 300)
  }, 3000)
}

// Animations CSS supplémentaires
const additionalStyles = `
  @keyframes slideInRight {
    from {
      transform: translateX(100%);
      opacity: 0;
    }
    to {
      transform: translateX(0);
      opacity: 1;
    }
  }
  
  @keyframes pulse {
    0%, 100% {
      transform: scale(1);
    }
    50% {
      transform: scale(1.1);
    }
  }
  
  .modal {
    position: fixed;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
    z-index: 1000;
  }
  
  .modal-content {
    background: white;
    border-radius: 12px;
    max-width: 500px;
    width: 90%;
    max-height: 80vh;
    overflow-y: auto;
  }
  
  .modal-header {
    padding: 1.5rem;
    border-bottom: 1px solid #eee;
    display: flex;
    justify-content: space-between;
    align-items: center;
  }
  
  .modal-close {
    background: none;
    border: none;
    font-size: 1.5rem;
    cursor: pointer;
  }
  
  .modal-body {
    padding: 1.5rem;
  }
`

// Ajouter les styles
const styleSheet = document.createElement("style")
styleSheet.textContent = additionalStyles
document.head.appendChild(styleSheet)
