// Fonctions pour les sections de catégories
function initCategorySections() {
  // Animation d'apparition progressive des sections
  const categorySections = document.querySelectorAll(".category-section")

  const observer = new IntersectionObserver(
    (entries) => {
      entries.forEach((entry, index) => {
        if (entry.isIntersecting) {
          setTimeout(() => {
            entry.target.style.opacity = "1"
            entry.target.style.transform = "translateY(0)"
          }, index * 200)
        }
      })
    },
    {
      threshold: 0.1,
    },
  )

  categorySections.forEach((section) => {
    section.style.opacity = "0"
    section.style.transform = "translateY(30px)"
    section.style.transition = "all 0.6s ease"
    observer.observe(section)
  })
}

// Gestion des cartes de performances
function initPerformanceCards() {
  const performanceCards = document.querySelectorAll(".performance-item")

  performanceCards.forEach((card) => {
    const cardElement = card.querySelector(".performance-card")

    // Effet parallax subtil
    card.addEventListener("mousemove", (e) => {
      const rect = card.getBoundingClientRect()
      const x = e.clientX - rect.left
      const y = e.clientY - rect.top

      const centerX = rect.width / 2
      const centerY = rect.height / 2

      const rotateX = (y - centerY) / 10
      const rotateY = (centerX - x) / 10

      cardElement.style.transform = `perspective(1000px) rotateX(${rotateX}deg) rotateY(${rotateY}deg) translateZ(10px)`
    })

    card.addEventListener("mouseleave", () => {
      cardElement.style.transform = "perspective(1000px) rotateX(0) rotateY(0) translateZ(0)"
    })

    // Animation au clic
    card.addEventListener("click", (e) => {
      if (!e.target.closest(".btn-favorite-card") && !e.target.closest(".performance-actions")) {
        cardElement.style.transform = "scale(0.95)"
        setTimeout(() => {
          cardElement.style.transform = ""
        }, 150)
      }
    })
  })
}

// Gestion des boutons favoris dans les cartes
function initCategoryFavorites() {
  const favoriteButtons = document.querySelectorAll(".btn-favorite-card")

  favoriteButtons.forEach((button) => {
    button.addEventListener("click", (e) => {
      e.stopPropagation()

      // Animation de clic
      button.style.transform = "scale(0.8) rotate(15deg)"
      setTimeout(() => {
        button.style.transform = ""
      }, 200)
    })
  })
}

// Animation des statistiques
function animateStats() {
  const statNumbers = document.querySelectorAll(".stat-number")

  const observer = new IntersectionObserver((entries) => {
    entries.forEach((entry) => {
      if (entry.isIntersecting) {
        const target = entry.target
        const finalValue = Number.parseFloat(target.textContent)
        let currentValue = 0
        const increment = finalValue / 30

        const timer = setInterval(() => {
          currentValue += increment
          if (currentValue >= finalValue) {
            currentValue = finalValue
            clearInterval(timer)
          }

          if (finalValue % 1 === 0) {
            target.textContent = Math.floor(currentValue)
          } else {
            target.textContent = currentValue.toFixed(1)
          }
        }, 50)

        observer.unobserve(target)
      }
    })
  })

  statNumbers.forEach((stat) => observer.observe(stat))
}

// Filtrage par catégorie
function initCategoryFiltering() {
  // Ajouter des boutons de filtrage rapide
  const mainContent = document.querySelector(".main")
  if (mainContent) {
    const filterContainer = document.createElement("div")
    filterContainer.className = "category-quick-filters"
    filterContainer.innerHTML = `
      <div class="quick-filter-header">
        <h4>🎯 Filtrage rapide</h4>
      </div>
      <div class="quick-filter-buttons">
        <button class="quick-filter-btn active" data-category="all">Tout</button>
        <button class="quick-filter-btn" data-category="comedie">Comédie</button>
        <button class="quick-filter-btn" data-category="drame">Drame</button>
        <button class="quick-filter-btn" data-category="musical">Musical</button>
        <button class="quick-filter-btn" data-category="classique">Classique</button>
      </div>
    `

    // Insérer avant les sections de catégories
    const firstCategorySection = document.querySelector(".category-section")
    if (firstCategorySection) {
      firstCategorySection.parentNode.insertBefore(filterContainer, firstCategorySection)
    }

    // Gestion des clics sur les filtres
    const filterButtons = filterContainer.querySelectorAll(".quick-filter-btn")
    filterButtons.forEach((button) => {
      button.addEventListener("click", () => {
        const category = button.dataset.category

        // Mettre à jour l'état actif
        filterButtons.forEach((btn) => btn.classList.remove("active"))
        button.classList.add("active")

        // Filtrer les sections
        const categorySections = document.querySelectorAll(".category-section")
        categorySections.forEach((section) => {
          if (category === "all" || section.dataset.category === category) {
            section.style.display = "block"
            section.style.animation = "slideInUp 0.6s ease forwards"
          } else {
            section.style.display = "none"
          }
        })
      })
    })
  }
}

// Initialiser toutes les fonctions au chargement
document.addEventListener("DOMContentLoaded", () => {
  initCategorySections()
  initPerformanceCards()
  initCategoryFavorites()
  animateStats()
  initCategoryFiltering()
})
