// JavaScript pour la page des catégories

document.addEventListener("DOMContentLoaded", () => {
  initCategories()
  initSorting()
  initSearch()
})

function initCategories() {
  console.log("Page catégories initialisée")

  // Animer les cartes de catégories
  animateCategoryCards()

  // Initialiser les interactions
  initCategoryInteractions()
}

function animateCategoryCards() {
  const cards = document.querySelectorAll(".category-card, .performance-card")

  cards.forEach((card, index) => {
    card.style.opacity = "0"
    card.style.transform = "translateY(20px)"

    setTimeout(() => {
      card.style.transition = "all 0.6s ease"
      card.style.opacity = "1"
      card.style.transform = "translateY(0)"
    }, index * 100)
  })
}

function initCategoryInteractions() {
  const categoryCards = document.querySelectorAll(".category-card")

  categoryCards.forEach((card) => {
    card.addEventListener("mouseenter", function () {
      this.style.transform = "translateY(-10px) scale(1.02)"
      this.style.boxShadow = "0 10px 25px rgba(0,0,0,0.15)"

      const arrow = this.querySelector(".category-arrow")
      if (arrow) {
        arrow.style.transform = "translateX(5px)"
      }
    })

    card.addEventListener("mouseleave", function () {
      this.style.transform = "translateY(0) scale(1)"
      this.style.boxShadow = ""

      const arrow = this.querySelector(".category-arrow")
      if (arrow) {
        arrow.style.transform = "translateX(0)"
      }
    })
  })

  // Interactions pour les cartes de spectacles
  const performanceCards = document.querySelectorAll(".performance-card")

  performanceCards.forEach((card) => {
    card.addEventListener("mouseenter", function () {
      this.style.transform = "translateY(-5px)"
      this.style.boxShadow = "0 8px 20px rgba(0,0,0,0.12)"
    })

    card.addEventListener("mouseleave", function () {
      this.style.transform = "translateY(0)"
      this.style.boxShadow = ""
    })
  })
}

function initSorting() {
  const sortButtons = document.querySelectorAll(".filter-btn[data-sort]")

  sortButtons.forEach((button) => {
    button.addEventListener("click", function () {
      // Retirer la classe active des autres boutons
      sortButtons.forEach((btn) => btn.classList.remove("active"))
      this.classList.add("active")

      const sortType = this.dataset.sort
      sortPerformances(sortType)
    })
  })
}

function sortPerformances(sortType) {
  const grid = document.querySelector(".performances-grid")
  const cards = Array.from(grid.querySelectorAll(".performance-card"))

  cards.sort((a, b) => {
    switch (sortType) {
      case "rating":
        const ratingA = Number.parseFloat(a.querySelector(".rating-text").textContent) || 0
        const ratingB = Number.parseFloat(b.querySelector(".rating-text").textContent) || 0
        return ratingB - ratingA

      case "title":
        const titleA = a.querySelector("h3").textContent
        const titleB = b.querySelector("h3").textContent
        return titleA.localeCompare(titleB)

      case "recent":
        // Trier par date de création (simulé par l'ordre dans le DOM)
        return 0

      case "available":
        const availableA = a.querySelector(".availability-badge") ? 1 : 0
        const availableB = b.querySelector(".availability-badge") ? 1 : 0
        return availableB - availableA

      default:
        return 0
    }
  })

  // Réorganiser les cartes avec animation
  cards.forEach((card, index) => {
    card.style.opacity = "0"
    card.style.transform = "scale(0.8)"

    setTimeout(() => {
      grid.appendChild(card)

      setTimeout(() => {
        card.style.transition = "all 0.4s ease"
        card.style.opacity = "1"
        card.style.transform = "scale(1)"
      }, 50)
    }, index * 50)
  })
}

function initSearch() {
  const searchInput = document.getElementById("searchInput")

  if (searchInput) {
    searchInput.addEventListener("input", function () {
      const query = this.value.toLowerCase()
      searchInCategory(query)
    })
  }
}

function searchInCategory(query) {
  const cards = document.querySelectorAll(".performance-card, .category-card")

  cards.forEach((card) => {
    const title = card.querySelector("h3").textContent.toLowerCase()
    const description = card.querySelector(".performance-description, .category-description")
    const descText = description ? description.textContent.toLowerCase() : ""

    if (title.includes(query) || descText.includes(query)) {
      card.style.display = "block"
      card.style.opacity = "1"
    } else {
      card.style.display = "none"
    }
  })

  // Vérifier s'il y a des résultats
  const visibleCards = document.querySelectorAll(
    ".performance-card:not([style*='display: none']), .category-card:not([style*='display: none'])",
  )

  if (visibleCards.length === 0 && query.length > 0) {
    showNoResults()
  } else {
    hideNoResults()
  }
}

function showNoResults() {
  let noResults = document.querySelector(".no-results")

  if (!noResults) {
    noResults = document.createElement("div")
    noResults.className = "no-results empty-state"
    noResults.innerHTML = `
      <div class="empty-icon">🔍</div>
      <h3>Aucun résultat trouvé</h3>
      <p>Essayez avec d'autres mots-clés</p>
    `

    const main = document.querySelector(".main")
    main.appendChild(noResults)
  }

  noResults.style.display = "block"
}

function hideNoResults() {
  const noResults = document.querySelector(".no-results")
  if (noResults) {
    noResults.style.display = "none"
  }
}

function toggleFavorite(performanceId) {
  fetch("api/favorites.php", {
    method: "POST",
    headers: {
      "Content-Type": "application/json",
    },
    body: JSON.stringify({
      performance_id: performanceId,
      action: "toggle",
    }),
  })
    .then((response) => response.json())
    .then((data) => {
      if (data.success) {
        updateFavoriteButton(performanceId, data.is_favorite)
        showNotification(data.is_favorite ? "Ajouté aux favoris" : "Retiré des favoris", "success")
      } else {
        showNotification("Erreur lors de la mise à jour", "error")
      }
    })
    .catch((error) => {
      console.error("Erreur:", error)
      showNotification("Erreur de connexion", "error")
    })
}

function updateFavoriteButton(performanceId, isFavorite) {
  const buttons = document.querySelectorAll(`[onclick*="toggleFavorite(${performanceId})"]`)
  buttons.forEach((button) => {
    button.classList.toggle("active", isFavorite)
  })
}

function showNotification(message, type) {
  const notification = document.createElement("div")
  notification.className = `notification ${type}`
  notification.textContent = message

  document.body.appendChild(notification)

  setTimeout(() => {
    notification.classList.add("show")
  }, 100)

  setTimeout(() => {
    notification.classList.remove("show")
    setTimeout(() => notification.remove(), 300)
  }, 3000)
}

// Fonction pour le bouton retour
function goBack() {
  window.history.back()
}
